/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.cas;

import org.apache.syncope.sra.ApplicationContextUtils;
import org.apache.syncope.sra.security.LogoutRouteMatcher;
import org.apache.syncope.sra.security.PublicRouteMatcher;
import org.apache.syncope.sra.security.cas.CASAuthenticationRequestWebFilter;
import org.apache.syncope.sra.security.cas.CASAuthenticationWebFilter;
import org.apache.syncope.sra.security.cas.CASServerLogoutHandler;
import org.apache.syncope.sra.security.cas.CASServerLogoutSuccessHandler;
import org.apereo.cas.client.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionServerSecurityContextRepository;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

public final class CASSecurityConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CASSecurityConfigUtils.class);

    private static ReactiveAuthenticationManager authenticationManager() {
        return authentication -> Mono.just((Object)authentication).filter(Authentication::isAuthenticated);
    }

    public static void forLogin(ServerHttpSecurity http, Protocol protocol, String casServerUrlPrefix, PublicRouteMatcher publicRouteMatcher) {
        ReactiveAuthenticationManager authenticationManager = CASSecurityConfigUtils.authenticationManager();
        CASAuthenticationRequestWebFilter authRequestFilter = new CASAuthenticationRequestWebFilter(publicRouteMatcher, protocol, casServerUrlPrefix);
        http.addFilterAt((WebFilter)authRequestFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        CASAuthenticationWebFilter authenticationFilter = new CASAuthenticationWebFilter(authenticationManager, protocol, casServerUrlPrefix);
        authenticationFilter.setAuthenticationFailureHandler((exchange, ex) -> Mono.error((Throwable)ex));
        authenticationFilter.setSecurityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
        http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION);
    }

    public static void forLogout(ServerHttpSecurity http, CacheManager cacheManager, String casServerUrlPrefix, LogoutRouteMatcher logoutRouteMatcher, ConfigurableApplicationContext ctx) {
        LogoutWebFilter logoutWebFilter = new LogoutWebFilter();
        logoutWebFilter.setRequiresLogoutMatcher((ServerWebExchangeMatcher)logoutRouteMatcher);
        logoutWebFilter.setLogoutHandler((ServerLogoutHandler)new CASServerLogoutHandler(cacheManager, casServerUrlPrefix));
        try {
            CASServerLogoutSuccessHandler handler = ApplicationContextUtils.getOrCreateBean(ctx, CASServerLogoutSuccessHandler.class.getName(), CASServerLogoutSuccessHandler.class);
            logoutWebFilter.setLogoutSuccessHandler((ServerLogoutSuccessHandler)handler);
        }
        catch (ClassNotFoundException e) {
            LOG.error("While creating instance of {}", (Object)CASServerLogoutSuccessHandler.class.getName(), (Object)e);
        }
        http.addFilterAt((WebFilter)logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
    }

    private CASSecurityConfigUtils() {
    }
}

