/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import org.apache.syncope.sra.security.pac4j.NoOpSessionStore;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.apache.syncope.sra.security.saml2.SAML2ServerLogoutSuccessHandler;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SAML2LogoutResponseWebFilter
implements WebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2LogoutResponseWebFilter.class);
    public static final ServerWebExchangeMatcher MATCHER = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/logout/saml2/sso"});
    private final SAML2Client saml2Client;
    private final ServerLogoutSuccessHandler logoutSuccessHandler;

    public SAML2LogoutResponseWebFilter(SAML2Client saml2Client, SAML2ServerLogoutSuccessHandler logoutSuccessHandler) {
        this.saml2Client = saml2Client;
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    private Mono<Void> handleLogoutResponse(ServerWebExchange exchange, WebFilterChain chain, ServerWebExchangeContext swec) {
        try {
            CallContext ctx = new CallContext((WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE);
            Credentials creds = (Credentials)this.saml2Client.getCredentialsExtractor().extract(ctx).orElseThrow(() -> new IllegalStateException("Could not extract credentials"));
            this.saml2Client.getLogoutProcessor().processLogout(ctx, creds);
        }
        catch (Exception e) {
            LOG.error("Could not validate LogoutResponse", (Throwable)e);
        }
        return this.logoutSuccessHandler.onLogoutSuccess(new WebFilterExchange(exchange, chain), null);
    }

    private Mono<Void> handleGET(ServerWebExchange exchange, WebFilterChain chain) {
        if (exchange.getRequest().getQueryParams().getFirst((Object)"SAMLResponse") != null) {
            return this.handleLogoutResponse(exchange, chain, new ServerWebExchangeContext(exchange));
        }
        return chain.filter(exchange).then(Mono.empty());
    }

    private Mono<Void> handlePOST(ServerWebExchange exchange, WebFilterChain chain) {
        return exchange.getFormData().filter(form -> form.containsKey((Object)"SAMLResponse")).flatMap(form -> this.handleLogoutResponse(exchange, chain, new ServerWebExchangeContext(exchange).setForm((MultiValueMap<String, String>)form))).or(chain.filter(exchange).then(Mono.empty()));
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return MATCHER.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> exchange.getRequest().getMethod() == HttpMethod.GET ? this.handleGET(exchange, chain) : (exchange.getRequest().getMethod() == HttpMethod.POST ? this.handlePOST(exchange, chain) : Mono.error(() -> new UnsupportedOperationException("Unsupported HTTP method: " + String.valueOf(exchange.getRequest().getMethod())))));
    }
}

