/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import java.net.URI;
import org.apache.syncope.sra.security.pac4j.NoOpSessionStore;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.apache.syncope.sra.security.saml2.SAML2AuthenticationToken;
import org.apache.syncope.sra.security.web.server.DoNothingIfCommittedServerRedirectStrategy;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SAML2WebSsoAuthenticationWebFilter
extends AuthenticationWebFilter {
    public static final String FILTER_PROCESSES_URI = "/login/saml2/sso";
    private static final ServerWebExchangeMatcher MATCHER = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/login/saml2/sso"});
    private final SAML2Client saml2Client;

    public SAML2WebSsoAuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager, SAML2Client saml2Client) {
        super(authenticationManager);
        this.saml2Client = saml2Client;
        this.setRequiresAuthenticationMatcher(this.matchSamlResponse());
        this.setServerAuthenticationConverter(this.convertSamlResponse());
        this.setAuthenticationSuccessHandler(this.redirectToInitialRequestURI());
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return super.filter(exchange, chain).then(Mono.defer(() -> ((ServerHttpResponse)exchange.getResponse()).setComplete()));
    }

    private ServerWebExchangeMatcher matchSamlResponse() {
        return exchange -> exchange.getFormData().filter(form -> form.containsKey((Object)"SAMLResponse")).flatMap(form -> ServerWebExchangeMatcher.MatchResult.match()).switchIfEmpty(ServerWebExchangeMatcher.MatchResult.notMatch());
    }

    private ServerAuthenticationConverter convertSamlResponse() {
        return exchange -> exchange.getFormData().flatMap(form -> MATCHER.matches(exchange).flatMap(matchResult -> {
            ServerWebExchangeContext swec = new ServerWebExchangeContext(exchange).setForm((MultiValueMap<String, String>)form);
            SAML2Credentials credentials = (SAML2Credentials)this.saml2Client.getCredentialsExtractor().extract((WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE).orElseThrow(() -> new IllegalStateException("No AuthnResponse found"));
            this.saml2Client.getAuthenticator().validate((Credentials)credentials, (WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE);
            return Mono.just((Object)((Object)new SAML2AuthenticationToken(credentials)));
        }));
    }

    private ServerAuthenticationSuccessHandler redirectToInitialRequestURI() {
        return new ServerAuthenticationSuccessHandler(){
            private final ServerRedirectStrategy redirectStrategy = new DoNothingIfCommittedServerRedirectStrategy();

            public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication authentication) {
                return webFilterExchange.getExchange().getSession().flatMap(session -> this.redirectStrategy.sendRedirect(webFilterExchange.getExchange(), (URI)session.getRequiredAttribute("INITIAL_REQUEST_URI")));
            }
        };
    }
}

