/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import org.apache.syncope.sra.ApplicationContextUtils;
import org.apache.syncope.sra.security.LogoutRouteMatcher;
import org.apache.syncope.sra.security.PublicRouteMatcher;
import org.apache.syncope.sra.security.saml2.SAML2AnonymousWebFilter;
import org.apache.syncope.sra.security.saml2.SAML2LogoutResponseWebFilter;
import org.apache.syncope.sra.security.saml2.SAML2RequestServerLogoutHandler;
import org.apache.syncope.sra.security.saml2.SAML2ServerLogoutSuccessHandler;
import org.apache.syncope.sra.security.saml2.SAML2WebSsoAuthenticationRequestWebFilter;
import org.apache.syncope.sra.security.saml2.SAML2WebSsoAuthenticationWebFilter;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionServerSecurityContextRepository;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

public final class SAML2SecurityConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2SecurityConfigUtils.class);

    private static ReactiveAuthenticationManager authenticationManager() {
        return authentication -> Mono.just((Object)authentication).filter(Authentication::isAuthenticated);
    }

    public static void forLogin(ServerHttpSecurity http, SAML2Client saml2Client, PublicRouteMatcher publicRouteMatcher) {
        ReactiveAuthenticationManager authenticationManager = SAML2SecurityConfigUtils.authenticationManager();
        SAML2WebSsoAuthenticationRequestWebFilter authRequestFilter = new SAML2WebSsoAuthenticationRequestWebFilter(saml2Client);
        http.addFilterAt((WebFilter)authRequestFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        SAML2WebSsoAuthenticationWebFilter authenticationFilter = new SAML2WebSsoAuthenticationWebFilter(authenticationManager, saml2Client);
        authenticationFilter.setAuthenticationFailureHandler((exchange, ex) -> Mono.error((Throwable)ex));
        authenticationFilter.setSecurityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
        http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        SAML2AnonymousWebFilter anonymousRedirectFilter = new SAML2AnonymousWebFilter(publicRouteMatcher);
        http.addFilterAt((WebFilter)anonymousRedirectFilter, SecurityWebFiltersOrder.AUTHENTICATION);
    }

    public static void forLogout(ServerHttpSecurity.AuthorizeExchangeSpec builder, SAML2Client saml2Client, CacheManager cacheManager, LogoutRouteMatcher logoutRouteMatcher, ConfigurableApplicationContext ctx) {
        LogoutWebFilter logoutWebFilter = new LogoutWebFilter();
        logoutWebFilter.setRequiresLogoutMatcher((ServerWebExchangeMatcher)logoutRouteMatcher);
        logoutWebFilter.setLogoutHandler((ServerLogoutHandler)new SAML2RequestServerLogoutHandler(saml2Client, cacheManager));
        logoutWebFilter.setLogoutSuccessHandler((exchange, authentication) -> Mono.empty());
        try {
            SAML2ServerLogoutSuccessHandler logoutSuccessHandler = ApplicationContextUtils.getOrCreateBean(ctx, SAML2ServerLogoutSuccessHandler.class.getName(), SAML2ServerLogoutSuccessHandler.class);
            SAML2LogoutResponseWebFilter logoutResponseWebFilter = new SAML2LogoutResponseWebFilter(saml2Client, logoutSuccessHandler, cacheManager);
            builder.and().addFilterAt((WebFilter)logoutResponseWebFilter, SecurityWebFiltersOrder.LOGOUT);
        }
        catch (ClassNotFoundException e) {
            LOG.error("While creating instance of {}", (Object)SAML2ServerLogoutSuccessHandler.class.getName(), (Object)e);
        }
        builder.and().addFilterAt((WebFilter)logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
    }

    private SAML2SecurityConfigUtils() {
    }
}

