/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.oauth2;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.syncope.sra.security.AbstractServerLogoutSuccessHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class OidcClientInitiatedServerLogoutSuccessHandler
extends AbstractServerLogoutSuccessHandler {
    @Autowired
    @Qualifier(value="oidcClientRegistrationRepository")
    private ReactiveClientRegistrationRepository clientRegistrationRepository;
    protected final RedirectServerLogoutSuccessHandler serverLogoutSuccessHandler = new RedirectServerLogoutSuccessHandler();

    public void setLogoutSuccessUrl(URI logoutSuccessUrl) {
        Assert.notNull((Object)logoutSuccessUrl, (String)"logoutSuccessUrl cannot be null");
        this.serverLogoutSuccessHandler.setLogoutSuccessUrl(logoutSuccessUrl);
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        return Mono.just((Object)authentication).filter(OAuth2AuthenticationToken.class::isInstance).filter(token -> authentication.getPrincipal() instanceof OidcUser).map(OAuth2AuthenticationToken.class::cast).flatMap(this::endSessionEndpoint).map(endSessionEndpoint -> this.endpointUri(exchange, (URI)endSessionEndpoint, authentication)).switchIfEmpty(this.serverLogoutSuccessHandler.onLogoutSuccess(exchange, authentication).then(Mono.empty())).flatMap(endpointUri -> this.redirectStrategy.sendRedirect(exchange.getExchange(), endpointUri));
    }

    private Mono<URI> endSessionEndpoint(OAuth2AuthenticationToken token) {
        String registrationId = token.getAuthorizedClientRegistrationId();
        return this.clientRegistrationRepository.findByRegistrationId(registrationId).map(ClientRegistration::getProviderDetails).map(ClientRegistration.ProviderDetails::getConfigurationMetadata).flatMap(configurationMetadata -> Mono.justOrEmpty(configurationMetadata.get("end_session_endpoint"))).map(Object::toString).map(URI::create);
    }

    private URI endpointUri(WebFilterExchange exchange, URI endSessionEndpoint, Authentication authentication) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{this.idToken(authentication)});
        URI postLogout = this.getPostLogout(exchange);
        builder.queryParam("post_logout_redirect_uri", new Object[]{postLogout});
        return builder.encode(StandardCharsets.UTF_8).build().toUri();
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }
}

