/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.security.saml2;

import org.apache.syncope.sra.security.pac4j.NoOpSessionStore;
import org.apache.syncope.sra.security.pac4j.RedirectionActionUtils;
import org.apache.syncope.sra.security.pac4j.ServerWebExchangeContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import reactor.core.publisher.Mono;

public class SAML2RequestServerLogoutHandler
implements ServerLogoutHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2RequestServerLogoutHandler.class);
    private final SAML2Client saml2Client;
    private final CacheManager cacheManager;

    public SAML2RequestServerLogoutHandler(SAML2Client saml2Client, CacheManager cacheManager) {
        this.saml2Client = saml2Client;
        this.cacheManager = cacheManager;
    }

    public Mono<Void> logout(WebFilterExchange exchange, Authentication authentication) {
        return exchange.getExchange().getSession().flatMap(session -> {
            SAML2Credentials credentials = (SAML2Credentials)authentication.getPrincipal();
            LOG.debug("Creating SAML2 SP Logout Request for IDP[{}] and Profile[{}]", (Object)this.saml2Client.getIdentityProviderResolvedEntityId(), (Object)credentials.getUserProfile());
            ServerWebExchangeContext swec = new ServerWebExchangeContext(exchange.getExchange());
            this.cacheManager.getCache("default").evictIfPresent((Object)session.getId());
            return session.invalidate().then(this.saml2Client.getLogoutAction((WebContext)swec, (SessionStore)NoOpSessionStore.INSTANCE, credentials.getUserProfile(), null).map(action -> RedirectionActionUtils.handle(action, swec)).orElseThrow(() -> new IllegalStateException("No action generated")));
        }).onErrorResume(Mono::error);
    }
}

