/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra;

import io.netty.channel.unix.Errors;
import java.net.ConnectException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.syncope.sra.RouteProvider;
import org.apache.syncope.sra.SRAProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

@Order(value=-2)
public class SyncopeSRAWebExceptionHandler
implements WebExceptionHandler,
ApplicationListener<RefreshRoutesEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeSRAWebExceptionHandler.class);
    private static final Map<String, Optional<URI>> CACHE = new ConcurrentHashMap<String, Optional<URI>>();
    private final RouteProvider routeProvider;
    private final SRAProperties props;

    public SyncopeSRAWebExceptionHandler(RouteProvider routeProvider, SRAProperties props) {
        this.routeProvider = routeProvider;
        this.props = props;
    }

    public void onApplicationEvent(RefreshRoutesEvent event) {
        CACHE.clear();
    }

    private URI getError(ServerWebExchange exchange) {
        Optional routeError;
        URI error = this.props.getGlobal().getError();
        String routeId = (String)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
        if (StringUtils.isNotBlank((CharSequence)routeId) && (routeError = Optional.ofNullable(CACHE.get(routeId)).orElseGet(() -> {
            Optional<SRARouteTO> route = this.routeProvider.getRouteTOs().stream().filter(r -> routeId.equals(r.getKey())).findFirst();
            URI uri = route.map(SRARouteTO::getError).orElse(null);
            CACHE.put(routeId, Optional.ofNullable(uri));
            return CACHE.get(routeId);
        })).isPresent()) {
            error = (URI)routeError.get();
        }
        return error;
    }

    private boolean acceptsTextHtml(ServerHttpRequest request) {
        try {
            List acceptedMediaTypes = request.getHeaders().getAccept();
            acceptedMediaTypes.remove(MediaType.ALL);
            MediaType.sortBySpecificityAndQuality((List)acceptedMediaTypes);
            return acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_HTML).isCompatibleWith(arg_0));
        }
        catch (InvalidMediaTypeException e) {
            LOG.debug("Unexpected exception", (Throwable)e);
            return false;
        }
    }

    private Mono<Void> doHandle(ServerWebExchange exchange, Throwable throwable, HttpStatus status) {
        try {
            if (this.acceptsTextHtml(exchange.getRequest())) {
                exchange.getResponse().setStatusCode(HttpStatus.SEE_OTHER);
                URI error = this.getError(exchange);
                exchange.getResponse().getHeaders().add("Location", error.toASCIIString());
            } else {
                exchange.getResponse().setStatusCode(status);
                exchange.getResponse().getHeaders().add("X-Application-Error-Code", HttpStatus.NOT_FOUND.toString());
                exchange.getResponse().getHeaders().add("X-Application-Error-Info", throwable.getMessage().replace("\n", " "));
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("Could not perform, ignoring", (Throwable)e);
        }
        return exchange.getResponse().setComplete();
    }

    public Mono<Void> handle(ServerWebExchange exchange, Throwable throwable) {
        if (throwable instanceof ConnectException || throwable instanceof Errors.NativeIoException || throwable instanceof NotFoundException) {
            LOG.error("ConnectException thrown", throwable);
            return this.doHandle(exchange, throwable, HttpStatus.NOT_FOUND);
        }
        if (throwable instanceof OAuth2AuthorizationException) {
            LOG.error("OAuth2AuthorizationException thrown", throwable);
            return this.doHandle(exchange, throwable, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return Mono.error((Throwable)throwable);
    }
}

