/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.opensearch.client;

import org.apache.http.HttpHost;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.opensearch.client.OpenSearchClientFactoryBean;
import org.apache.syncope.ext.opensearch.client.OpenSearchIndexLoader;
import org.apache.syncope.ext.opensearch.client.OpenSearchIndexManager;
import org.apache.syncope.ext.opensearch.client.OpenSearchProperties;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.apache.syncope.ext.opensearch.client.SyncopeOpenSearchHealthContributor;
import org.identityconnectors.common.CollectionUtil;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@EnableConfigurationProperties(value={OpenSearchProperties.class})
@Configuration(proxyBeanMethods=false)
public class OpenSearchClientContext {
    @ConditionalOnMissingBean
    @Bean
    public OpenSearchClientFactoryBean openSearchClientFactoryBean(OpenSearchProperties props) {
        return new OpenSearchClientFactoryBean(CollectionUtil.nullAsEmpty(props.getHosts()).stream().map(HttpHost::create).toList());
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenSearchUtils openSearchUtils(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO) {
        return new OpenSearchUtils(userDAO, groupDAO, anyObjectDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenSearchIndexManager openSearchIndexManager(OpenSearchProperties props, OpenSearchClient client, OpenSearchUtils openSearchUtils) {
        return new OpenSearchIndexManager(client, openSearchUtils, props.getNumberOfShards(), props.getNumberOfReplicas());
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenSearchIndexLoader openSearchIndexLoader(OpenSearchIndexManager indexManager) {
        return new OpenSearchIndexLoader(indexManager);
    }

    @ConditionalOnMissingBean(name={"syncopeOpenSearchHealthContributor"})
    @Bean(name={"syncopeOpenSearchHealthContributor", "openSearchHealthIndicator", "openSearchHealthContributor"})
    public HealthContributor syncopeOpenSearchHealthContributor(OpenSearchClient client) {
        return new SyncopeOpenSearchHealthContributor(client);
    }
}

