/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.OpenFGAClient;
import org.apache.syncope.ext.openfga.client.OpenFGAProperties;
import org.apache.syncope.ext.openfga.client.model.AuthorizationModel;
import org.apache.syncope.ext.openfga.client.model.CreateStoreRequest;
import org.apache.syncope.ext.openfga.client.model.Metadata;
import org.apache.syncope.ext.openfga.client.model.RelationMetadata;
import org.apache.syncope.ext.openfga.client.model.RelationReference;
import org.apache.syncope.ext.openfga.client.model.Store;
import org.apache.syncope.ext.openfga.client.model.TypeDefinition;
import org.apache.syncope.ext.openfga.client.model.Userset;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelRequest;

public class OpenFGAClientFactory {
    public static final String MEMBERSHIP_RELATION = "member";
    public static final String SCHEMA_VERSION = "1.1";
    protected final ApiClient apiClient;
    protected final OpenFGAProperties properties;
    protected final Map<String, OpenFGAClient> clients = new ConcurrentHashMap<String, OpenFGAClient>();

    protected static String storeId(String domain) {
        return StringUtils.rightPad((String)domain.toUpperCase(), (int)26, (char)'0');
    }

    public OpenFGAClientFactory(ApiClient openFgaApiClient, OpenFGAProperties properties) {
        this.apiClient = openFgaApiClient;
        this.properties = properties;
    }

    public String getBaseUri() {
        return this.apiClient.getBaseUri();
    }

    public void initAuthorizationModel(OpenFGAClient client, String domain, boolean force) throws Exception {
        String storeId = client.listStores().getStores().stream().filter(store -> domain.equals(store.getName())).findFirst().map(Store::getId).orElse(null);
        if (storeId == null) {
            storeId = client.createStore(new CreateStoreRequest().name(domain)).getId();
        }
        client.setStoreId(storeId);
        WriteAuthorizationModelRequest request = new WriteAuthorizationModelRequest().schemaVersion(SCHEMA_VERSION).addTypeDefinitionsItem(new TypeDefinition().type(AnyTypeKind.USER.name()).relations(Map.of())).addTypeDefinitionsItem(new TypeDefinition().type(AnyTypeKind.GROUP.name()).putRelationsItem(MEMBERSHIP_RELATION, new Userset()._this(Map.of())).metadata(new Metadata().putRelationsItem(MEMBERSHIP_RELATION, new RelationMetadata().addDirectlyRelatedUserTypesItem(new RelationReference().type(AnyTypeKind.USER.name())))));
        if (force) {
            client.setAuthorizationModelId(client.writeAuthorizationModel(request).getAuthorizationModelId());
        } else {
            List<AuthorizationModel> models = client.readAuthorizationModels().getAuthorizationModels();
            if (models.isEmpty()) {
                client.setAuthorizationModelId(client.writeAuthorizationModel(request).getAuthorizationModelId());
            } else {
                client.setAuthorizationModelId(models.getFirst().getId());
            }
        }
    }

    public OpenFGAClient get(String domain) {
        return this.clients.computeIfAbsent(domain, d -> {
            try {
                OpenFGAClient client = new OpenFGAClient(this.apiClient);
                this.initAuthorizationModel(client, domain, false);
                return client;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not init OpenFga client for domain " + d, e);
            }
        });
    }

    public void remove(String domain) {
        this.clients.remove(domain);
    }
}

