/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.WriteRequestDeletes;
import org.apache.syncope.ext.openfga.client.model.WriteRequestWrites;

@JsonPropertyOrder(value={"writes", "deletes", "authorization_model_id"})
public class WriteRequest {
    public static final String JSON_PROPERTY_WRITES = "writes";
    @Nullable
    private WriteRequestWrites writes;
    public static final String JSON_PROPERTY_DELETES = "deletes";
    @Nullable
    private WriteRequestDeletes deletes;
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    @Nullable
    private String authorizationModelId;

    public WriteRequest writes(@Nullable WriteRequestWrites writes) {
        this.writes = writes;
        return this;
    }

    @Nullable
    @JsonProperty(value="writes", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WriteRequestWrites getWrites() {
        return this.writes;
    }

    @JsonProperty(value="writes", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWrites(@Nullable WriteRequestWrites writes) {
        this.writes = writes;
    }

    public WriteRequest deletes(@Nullable WriteRequestDeletes deletes) {
        this.deletes = deletes;
        return this;
    }

    @Nullable
    @JsonProperty(value="deletes", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WriteRequestDeletes getDeletes() {
        return this.deletes;
    }

    @JsonProperty(value="deletes", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeletes(@Nullable WriteRequestDeletes deletes) {
        this.deletes = deletes;
    }

    public WriteRequest authorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteRequest writeRequest = (WriteRequest)o;
        return Objects.equals(this.writes, writeRequest.writes) && Objects.equals(this.deletes, writeRequest.deletes) && Objects.equals(this.authorizationModelId, writeRequest.authorizationModelId);
    }

    public int hashCode() {
        return Objects.hash(this.writes, this.deletes, this.authorizationModelId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WriteRequest {\n");
        sb.append("    writes: ").append(this.toIndentedString(this.writes)).append("\n");
        sb.append("    deletes: ").append(this.toIndentedString(this.deletes)).append("\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getWrites() != null) {
            joiner.add(this.getWrites().toUrlQueryString((String)prefix + JSON_PROPERTY_WRITES + suffix));
        }
        if (this.getDeletes() != null) {
            joiner.add(this.getDeletes().toUrlQueryString((String)prefix + JSON_PROPERTY_DELETES + suffix));
        }
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format(Locale.ROOT, "%sauthorization_model_id%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getAuthorizationModelId()))));
        }
        return joiner.toString();
    }
}

