/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.oidcc4ui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.common.lib.oidc.OIDCRequest;
import org.apache.syncope.common.rest.api.service.OIDCC4UIService;
import org.apache.wicket.Session;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="oidcc4ui.login", path="/oidcc4ui/login")
public class LoginResource
extends AbstractResource {
    private static final long serialVersionUID = -3076690953674174306L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        String op = attributes.getRequest().getQueryParameters().getParameterValue("op").toString();
        HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        String redirectURI = StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/login") + "/code-consumer";
        OIDCC4UIService service = (OIDCC4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getAnonymousService(OIDCC4UIService.class);
        OIDCRequest loginRequest = service.createLoginRequest(redirectURI, op);
        Session.get().setAttribute("op", (Serializable)((Object)op));
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setStatusCode(Integer.valueOf(Response.Status.FOUND.getStatusCode()));
        response.getHeaders().addHeader("Cache-Control", "no-cache, no-store");
        response.getHeaders().addHeader("Pragma", "no-cache");
        response.getHeaders().addHeader("Location", loginRequest.getLocation());
        return response;
    }
}

