/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.idm.engine.impl.UserQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SyncopeUserQueryImpl
extends UserQueryImpl {
    private static final long serialVersionUID = 4403344392227706318L;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    private List<org.flowable.idm.api.User> result;

    private static org.flowable.idm.api.User fromSyncopeUser(User syncopeUser) {
        UserEntityImpl user = new UserEntityImpl();
        user.setId(syncopeUser.getUsername());
        return user;
    }

    private void execute() {
        if (this.id != null) {
            User user2 = this.userDAO.findByUsername(this.id);
            if (user2 == null) {
                this.result = List.of();
            } else if (this.groupId == null || this.userDAO.findAllGroupNames(user2).contains(this.groupId)) {
                this.result = List.of(SyncopeUserQueryImpl.fromSyncopeUser(user2));
            }
        } else if (this.groupId != null) {
            Group group = this.groupDAO.findByName(this.groupId);
            if (group == null) {
                this.result = List.of();
            } else {
                this.result = new ArrayList<org.flowable.idm.api.User>();
                List memberships = this.groupDAO.findUMemberships(group);
                memberships.stream().map(membership -> SyncopeUserQueryImpl.fromSyncopeUser((User)membership.getLeftEnd())).filter(user -> !this.result.contains(user)).forEachOrdered(user -> this.result.add((org.flowable.idm.api.User)user));
            }
        }
    }

    @Transactional(readOnly=true)
    public long count() {
        this.checkQueryOk();
        this.resultType = ListQueryParameterObject.ResultType.COUNT;
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    @Transactional(readOnly=true)
    public List<org.flowable.idm.api.User> list() {
        this.checkQueryOk();
        this.resultType = ListQueryParameterObject.ResultType.LIST;
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }
}

