/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);

    public static Pair<Properties, File> read(Class<?> clazz, String propertiesFileName, String confDirProp) {
        Properties props = new Properties();
        File confDir = null;
        try (InputStream is = clazz.getResourceAsStream("/" + propertiesFileName);){
            props.load(is);
            String confDirName = props.getProperty(confDirProp);
            if (confDirName != null) {
                confDir = new File(confDirName);
                if (confDir.exists() && confDir.canRead() && confDir.isDirectory()) {
                    File confDirProps = new File(confDir, propertiesFileName);
                    if (confDirProps.exists() && confDirProps.canRead() && confDirProps.isFile()) {
                        props.clear();
                        props.load(new FileInputStream(confDirProps));
                    }
                } else {
                    confDir = null;
                    LOG.warn("{} not existing, unreadable or not a directory, ignoring", (Object)confDirName);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read " + propertiesFileName, e);
        }
        return Pair.of((Object)props, (Object)confDir);
    }

    private PropertyUtils() {
    }
}

