/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.patch;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;

@XmlRootElement(name="deassociationPatch")
@XmlType
public class DeassociationPatch
extends AbstractBaseBean {
    private static final long serialVersionUID = 6295778399633883767L;
    private String key;
    private ResourceDeassociationAction action;
    private final List<String> resources = new ArrayList<String>();

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public ResourceDeassociationAction getAction() {
        return this.action;
    }

    @PathParam(value="action")
    public void setAction(ResourceDeassociationAction action) {
        this.action = action;
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    public static class Builder {
        private final DeassociationPatch instance = new DeassociationPatch();

        public Builder key(String key) {
            this.instance.setKey(key);
            return this;
        }

        public Builder action(ResourceDeassociationAction action) {
            this.instance.setAction(action);
            return this;
        }

        public Builder resource(String resource) {
            if (resource != null) {
                this.instance.getResources().add(resource);
            }
            return this;
        }

        public Builder resources(String ... resources) {
            this.instance.getResources().addAll(Arrays.asList(resources));
            return this;
        }

        public Builder resources(Collection<String> resources) {
            if (resources != null) {
                this.instance.getResources().addAll(resources);
            }
            return this;
        }

        public DeassociationPatch build() {
            return this.instance;
        }
    }
}

