/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.model.CustomTemplateInfo;
import org.apache.syncope.client.enduser.pages.HomePage;
import org.apache.syncope.client.enduser.resources.CaptchaResource;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.PropertyUtils;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeEnduserApplication
extends WebApplication
implements Serializable {
    private static final long serialVersionUID = -6445919351044845120L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeEnduserApplication.class);
    private static final String ENDUSER_PROPERTIES = "enduser.properties";
    private static final String CUSTOM_FORM_ATTRIBUTES_FILE = "customFormAttributes.json";
    private static final String CUSTOM_TEMPLATE_FILE = "customTemplate.json";
    private String domain;
    private String adminUser;
    private String anonymousUser;
    private String anonymousKey;
    private boolean captchaEnabled;
    private boolean xsrfEnabled;
    private Integer maxUploadFileSizeMB;
    private SyncopeClientFactoryBean clientFactory;
    private Map<String, CustomAttributesInfo> customFormAttributes;
    private CustomTemplateInfo customTemplate;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static SyncopeEnduserApplication get() {
        return (SyncopeEnduserApplication)WebApplication.get();
    }

    protected void init() {
        FileAlterationListenerAdaptor listener;
        FileAlterationMonitor monitor;
        FileAlterationObserver observer;
        File enduserDir;
        Object object;
        InputStream is;
        super.init();
        Properties props = (Properties)PropertyUtils.read(this.getClass(), (String)ENDUSER_PROPERTIES, (String)"enduser.directory").getLeft();
        this.domain = props.getProperty("domain", "Master");
        this.adminUser = props.getProperty("adminUser");
        Args.notNull((Object)this.adminUser, (String)"<adminUser>");
        this.anonymousUser = props.getProperty("anonymousUser");
        Args.notNull((Object)this.anonymousUser, (String)"<anonymousUser>");
        this.anonymousKey = props.getProperty("anonymousKey");
        Args.notNull((Object)this.anonymousKey, (String)"<anonymousKey>");
        this.captchaEnabled = Boolean.parseBoolean(props.getProperty("captcha"));
        Args.notNull((Object)this.captchaEnabled, (String)"<captcha>");
        this.xsrfEnabled = Boolean.parseBoolean(props.getProperty("xsrf"));
        Args.notNull((Object)this.xsrfEnabled, (String)"<xsrf>");
        String scheme = props.getProperty("scheme");
        Args.notNull((Object)scheme, (String)"<scheme>");
        String host = props.getProperty("host");
        Args.notNull((Object)host, (String)"<host>");
        String port = props.getProperty("port");
        Args.notNull((Object)port, (String)"<port>");
        String rootPath = props.getProperty("rootPath");
        Args.notNull((Object)rootPath, (String)"<rootPath>");
        String useGZIPCompression = props.getProperty("useGZIPCompression");
        Args.notNull((Object)useGZIPCompression, (String)"<useGZIPCompression>");
        this.maxUploadFileSizeMB = props.getProperty("maxUploadFileSizeMB") == null ? null : Integer.valueOf(props.getProperty("maxUploadFileSizeMB"));
        this.clientFactory = new SyncopeClientFactoryBean().setAddress(scheme + "://" + host + ":" + port + StringUtils.prependIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).setContentType(SyncopeClientFactoryBean.ContentType.JSON).setUseCompression(BooleanUtils.toBoolean((String)useGZIPCompression));
        try {
            is = this.getClass().getResourceAsStream("/customFormAttributes.json");
            object = null;
            try {
                File customFormAttributesFile;
                boolean bl;
                this.customFormAttributes = (Map)MAPPER.readValue(is, (TypeReference)new TypeReference<HashMap<String, CustomAttributesInfo>>(){});
                enduserDir = new File(props.getProperty("enduser.directory"));
                boolean bl2 = bl = enduserDir.exists() && enduserDir.canRead() && enduserDir.isDirectory();
                if (bl && (customFormAttributesFile = FileUtils.getFile((File)enduserDir, (String[])new String[]{CUSTOM_FORM_ATTRIBUTES_FILE})).exists() && customFormAttributesFile.canRead() && customFormAttributesFile.isFile()) {
                    this.customFormAttributes = (Map)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)customFormAttributesFile), (TypeReference)new TypeReference<HashMap<String, CustomAttributesInfo>>(){});
                }
                observer = bl ? new FileAlterationObserver(enduserDir, pathname -> StringUtils.contains((CharSequence)pathname.getPath(), (CharSequence)CUSTOM_FORM_ATTRIBUTES_FILE)) : new FileAlterationObserver(this.getClass().getResource("/customFormAttributes.json").getFile(), pathname -> StringUtils.contains((CharSequence)pathname.getPath(), (CharSequence)CUSTOM_FORM_ATTRIBUTES_FILE));
                monitor = new FileAlterationMonitor(5000L);
                listener = new FileAlterationListenerAdaptor(){

                    public void onFileChange(File file) {
                        try {
                            LOG.trace("{} has changed. Reloading form attributes customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_ATTRIBUTES_FILE);
                            SyncopeEnduserApplication.this.customFormAttributes = (Map)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)file), (TypeReference)new TypeReference<HashMap<String, CustomAttributesInfo>>(){});
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }

                    public void onFileCreate(File file) {
                        try {
                            LOG.trace("{} has been created. Loading form attributes customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_ATTRIBUTES_FILE);
                            SyncopeEnduserApplication.this.customFormAttributes = (Map)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)file), (TypeReference)new TypeReference<HashMap<String, CustomAttributesInfo>>(){});
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }

                    public void onFileDelete(File file) {
                        LOG.trace("{} has been deleted. Resetting form attributes customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_ATTRIBUTES_FILE);
                        SyncopeEnduserApplication.this.customFormAttributes = null;
                    }
                };
                observer.addListener((FileAlterationListener)listener);
                monitor.addObserver(observer);
                monitor.start();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not read customFormAttributes.json", (Throwable)e);
        }
        try {
            is = this.getClass().getResourceAsStream("/customTemplate.json");
            object = null;
            try {
                File customTemplateFile;
                boolean bl;
                this.customTemplate = (CustomTemplateInfo)MAPPER.readValue(is, CustomTemplateInfo.class);
                enduserDir = new File(props.getProperty("enduser.directory"));
                boolean bl3 = bl = enduserDir.exists() && enduserDir.canRead() && enduserDir.isDirectory();
                if (bl && (customTemplateFile = FileUtils.getFile((File)enduserDir, (String[])new String[]{CUSTOM_TEMPLATE_FILE})).exists() && customTemplateFile.canRead() && customTemplateFile.isFile()) {
                    this.customTemplate = (CustomTemplateInfo)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)customTemplateFile), CustomTemplateInfo.class);
                }
                observer = bl ? new FileAlterationObserver(enduserDir, pathname -> StringUtils.contains((CharSequence)pathname.getPath(), (CharSequence)CUSTOM_TEMPLATE_FILE)) : new FileAlterationObserver(this.getClass().getResource("/customTemplate.json").getFile(), pathname -> StringUtils.contains((CharSequence)pathname.getPath(), (CharSequence)CUSTOM_TEMPLATE_FILE));
                monitor = new FileAlterationMonitor(5000L);
                listener = new FileAlterationListenerAdaptor(){

                    public void onFileChange(File file) {
                        try {
                            LOG.trace("{} has changed. Reloading app customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_TEMPLATE_FILE);
                            SyncopeEnduserApplication.this.customTemplate = (CustomTemplateInfo)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)file), CustomTemplateInfo.class);
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }

                    public void onFileCreate(File file) {
                        try {
                            LOG.trace("{} has been created. Loading app customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_TEMPLATE_FILE);
                            SyncopeEnduserApplication.this.customTemplate = (CustomTemplateInfo)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)file), CustomTemplateInfo.class);
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }

                    public void onFileDelete(File file) {
                        LOG.trace("{} has been deleted. Resetting app customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_TEMPLATE_FILE);
                        SyncopeEnduserApplication.this.customTemplate = null;
                    }
                };
                observer.addListener((FileAlterationListener)listener);
                monitor.addObserver(observer);
                monitor.start();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not read customTemplate.json", (Throwable)e);
        }
        ClassPathScanImplementationLookup lookup = (ClassPathScanImplementationLookup)this.getServletContext().getAttribute("CLASSPATH_LOOKUP");
        for (Class clazz : lookup.getResources()) {
            Resource annotation = clazz.getAnnotation(Resource.class);
            if (annotation == null) {
                LOG.debug("No @Resource annotation found on {}, ignoring", (Object)clazz.getName());
                continue;
            }
            try {
                final AbstractResource instance = (AbstractResource)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.mountResource(annotation.path(), new ResourceReference(annotation.key()){
                    private static final long serialVersionUID = -128426276529456602L;

                    public IResource getResource() {
                        return instance;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Could not instantiate {}", (Object)clazz.getName(), (Object)e);
            }
        }
        if (this.captchaEnabled) {
            this.mountResource("/api/captcha", new ResourceReference("captcha"){
                private static final long serialVersionUID = -128426276529456602L;

                public IResource getResource() {
                    return new CaptchaResource();
                }
            });
        }
        this.getRequestCycleListeners().add((Object)new IRequestCycleListener(){

            public void onEndRequest(RequestCycle cycle) {
                if (cycle.getResponse() instanceof WebResponse) {
                    WebResponse response = (WebResponse)cycle.getResponse();
                    response.setHeader("X-XSS-Protection", "1; mode=block");
                    response.setHeader("X-Content-Type-Options", "nosniff");
                    response.setHeader("X-Frame-Options", "sameorigin");
                }
            }
        });
    }

    public Class<? extends Page> getHomePage() {
        return HomePage.class;
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeEnduserSession(request);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public SyncopeClientFactoryBean getClientFactory() {
        return this.clientFactory;
    }

    public boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    public boolean isXsrfEnabled() {
        return this.xsrfEnabled;
    }

    public Integer getMaxUploadFileSizeMB() {
        return this.maxUploadFileSizeMB;
    }

    public Map<String, CustomAttributesInfo> getCustomFormAttributes() {
        return this.customFormAttributes;
    }

    public void setCustomFormAttributes(Map<String, CustomAttributesInfo> customFormAttributes) {
        this.customFormAttributes.clear();
        this.customFormAttributes.putAll(customFormAttributes);
    }

    public void setCustomTemplate(CustomTemplateInfo customTemplate) {
        this.customTemplate = customTemplate;
    }

    public CustomTemplateInfo getCustomTemplate() {
        return this.customTemplate;
    }
}

