/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceConnCapabilitiesPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceConnConfPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceDetailsPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceSecurityPanel;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class ResourceWizardBuilder
extends AbstractResourceWizardBuilder<ResourceTO> {
    private static final long serialVersionUID = 1734415311027284221L;
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private boolean createFlag;

    public ResourceWizardBuilder(ResourceTO resourceTO, PageReference pageRef) {
        super(resourceTO, pageRef);
    }

    @Override
    public AjaxWizard<Serializable> build(String id, AjaxWizard.Mode mode) {
        this.createFlag = mode == AjaxWizard.Mode.CREATE;
        return super.build(id, mode);
    }

    @Override
    protected WizardModel buildModelSteps(final Serializable modelObject, WizardModel wizardModel) {
        final ResourceTO resourceTO = (ResourceTO)ResourceTO.class.cast(modelObject);
        final ResourceDetailsPanel resourceDetailsPanel = new ResourceDetailsPanel(resourceTO, this.createFlag);
        final ResourceConnConfPanel resourceConnConfPanel = new ResourceConnConfPanel(resourceTO, this.createFlag){
            private static final long serialVersionUID = -1128269449868933504L;

            @Override
            protected Pair<Boolean, String> check(AjaxRequestTarget target) {
                return ResourceWizardBuilder.this.resourceRestClient.check((ResourceTO)this.modelObject);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.append("class", (CharSequence)"scrollable-tab-content", " ");
            }
        };
        if (this.createFlag && resourceDetailsPanel.getConnector() != null) {
            resourceDetailsPanel.getConnector().getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = 4600298808455564695L;

                protected void onUpdate(AjaxRequestTarget target) {
                    resourceTO.setConnector((String)resourceDetailsPanel.getConnector().getModelObject());
                    LoadableDetachableModel<List<ConnConfProperty>> model = new LoadableDetachableModel<List<ConnConfProperty>>(){
                        private static final long serialVersionUID = -2965284931860212687L;

                        protected List<ConnConfProperty> load() {
                            List<ConnConfProperty> confOverride = resourceConnConfPanel.getConnProperties(resourceTO);
                            resourceTO.getConfOverride().clear();
                            resourceTO.getConfOverride().addAll(confOverride);
                            return new PropertyModel<List<ConnConfProperty>>((Object)modelObject, "confOverride"){
                                private static final long serialVersionUID = -7809699384012595307L;

                                public List<ConnConfProperty> getObject() {
                                    ArrayList<ConnConfProperty> res = new ArrayList<ConnConfProperty>((Collection)super.getObject());
                                    Collections.sort(res, (left, right) -> {
                                        if (left == null) {
                                            return -1;
                                        }
                                        return left.compareTo(right);
                                    });
                                    return res;
                                }
                            }.getObject();
                        }
                    };
                    resourceConnConfPanel.setConfPropertyListView((IModel<List<ConnConfProperty>>)model, true);
                    target.add(new Component[]{resourceConnConfPanel.getCheck().setVisible(true).setEnabled(true)});
                }
            }});
        }
        wizardModel.add((IWizardStep)resourceDetailsPanel);
        wizardModel.add((IWizardStep)resourceConnConfPanel);
        if (resourceTO.getConnector() != null) {
            wizardModel.add((IWizardStep)new ResourceConnCapabilitiesPanel(resourceTO, this.connectorRestClient.read(resourceTO.getConnector()).getCapabilities()));
        } else {
            wizardModel.add((IWizardStep)new ResourceConnCapabilitiesPanel(resourceTO, Collections.emptySet()));
        }
        wizardModel.add((IWizardStep)new ResourceSecurityPanel(resourceTO));
        return wizardModel;
    }

    protected ResourceTO onApplyInternal(Serializable modelObject) {
        ResourceTO resourceTO = (ResourceTO)modelObject;
        if (this.createFlag) {
            resourceTO = this.resourceRestClient.create(resourceTO);
        } else {
            this.resourceRestClient.update(resourceTO);
        }
        return resourceTO;
    }

    @Override
    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        ResourceTO actual = (ResourceTO)ResourceTO.class.cast(afterObject);
        return new AbstractResourceWizardBuilder.CreateEvent(actual.getKey(), actual.getKey(), TopologyNode.Kind.RESOURCE, (Serializable)((Object)actual.getConnector()), target);
    }
}

