/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedAccountDetailsPanel
extends WizardStep {
    private static final long serialVersionUID = 1221037007528732347L;
    private static final Logger LOG = LoggerFactory.getLogger(LinkedAccountDetailsPanel.class);
    private static final int SEARCH_SIZE = 20;
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();
    private List<String> connObjectKeyFieldValues;

    public LinkedAccountDetailsPanel(LinkedAccountTO linkedAccountTO) {
        this.setOutputMarkupId(true);
        final AjaxDropDownChoicePanel dropdownResourceField = new AjaxDropDownChoicePanel("resource", "resource", new PropertyModel((Object)linkedAccountTO, "resource"), false);
        dropdownResourceField.setChoices(this.resourceRestClient.list().stream().filter(resource -> resource.getProvision(AnyTypeKind.USER.name()).isPresent() && ((ProvisionTO)resource.getProvision(AnyTypeKind.USER.name()).get()).getMapping() != null && !((ProvisionTO)resource.getProvision(AnyTypeKind.USER.name()).get()).getMapping().getItems().isEmpty()).map(resource -> resource.getKey()).collect(Collectors.toList()));
        dropdownResourceField.setOutputMarkupId(true);
        dropdownResourceField.addRequiredLabel();
        dropdownResourceField.setNullValid(false);
        dropdownResourceField.setRequired(true);
        this.add(new Component[]{dropdownResourceField});
        String connObjectKeyFieldId = "connObjectKeyValue";
        final AjaxTextFieldPanel connObjectKeyField = new AjaxTextFieldPanel("connObjectKeyValue", "connObjectKeyValue", (IModel<String>)new PropertyModel((Object)linkedAccountTO, "connObjectKeyValue"), false);
        connObjectKeyField.setOutputMarkupId(true);
        connObjectKeyField.addRequiredLabel();
        connObjectKeyField.setChoices(Collections.emptyList());
        connObjectKeyField.setEnabled(false);
        this.add(new Component[]{connObjectKeyField});
        dropdownResourceField.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean enabled = dropdownResourceField.getModelObject() != null && !((String)dropdownResourceField.getModelObject()).isEmpty();
                connObjectKeyField.setEnabled(enabled);
                if (enabled) {
                    LinkedAccountDetailsPanel.this.setConnObjectFieldChoices(connObjectKeyField, (String)dropdownResourceField.getModelObject(), null);
                }
                target.add(new Component[]{connObjectKeyField});
            }
        }});
        connObjectKeyField.getField().setMarkupId("connObjectKeyValue");
        connObjectKeyField.getField().add(new Behavior[]{new AjaxEventBehavior("keydown"){
            private static final long serialVersionUID = 3533589614190959822L;

            protected void onEvent(AjaxRequestTarget target) {
                String searchTerm = connObjectKeyField.getField().getInput();
                if (StringUtils.isNotBlank((CharSequence)searchTerm) && searchTerm.length() > 1) {
                    LinkedAccountDetailsPanel.this.setConnObjectFieldChoices(connObjectKeyField, (String)dropdownResourceField.getModelObject(), searchTerm);
                    target.appendJavaScript((CharSequence)(LinkedAccountDetailsPanel.this.connObjectKeyFieldValues.isEmpty() ? "$('#connObjectKeyValue-autocomplete-container').hide();" : "var simulatedEvent = new KeyboardEvent('keydown', {keyCode: 40, which: 40}); document.getElementById('connObjectKeyValue').dispatchEvent(simulatedEvent);"));
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxCallListener listener = new AjaxCallListener(){
                    private static final long serialVersionUID = 2208168001920794667L;

                    public CharSequence getPrecondition(Component component) {
                        return "var keycode = Wicket.Event.keyCode(attrs.event); if ((keycode == 40) || (keycode == 38)) {return false;} return true;";
                    }
                };
                attributes.getAjaxCallListeners().add(listener);
                attributes.setThrottlingSettings(new ThrottlingSettings("id", Duration.seconds((double)1.2), true));
            }
        }});
    }

    private void setConnObjectFieldChoices(AjaxTextFieldPanel ajaxTextFieldPanel, String resource, String searchTerm) {
        AtomicReference<String> resourceRemoteKey = new AtomicReference<String>("__NAME__");
        try {
            resourceRemoteKey.set(((ProvisionTO)this.resourceRestClient.read(resource).getProvision(AnyTypeKind.USER.name()).get()).getMapping().getConnObjectKeyItem().getExtAttrName());
        }
        catch (Exception ex) {
            LOG.error("While reading mapping for resource {}", (Object)resource, (Object)ex);
        }
        ConnObjectTOQuery.Builder builder = new ConnObjectTOQuery.Builder().size(Integer.valueOf(20));
        if (StringUtils.isNotBlank((CharSequence)searchTerm)) {
            builder.fiql(SyncopeClient.getConnObjectTOFiqlSearchConditionBuilder().is(resourceRemoteKey.get()).equalTo(searchTerm + "*", new String[0]).query()).build();
        }
        Pair<String, List<ConnObjectTO>> items = this.resourceRestClient.searchConnObjects(resource, AnyTypeKind.USER.name(), builder, (SortParam<String>)new SortParam((Object)resourceRemoteKey.get(), true));
        this.connObjectKeyFieldValues = ((List)items.getRight()).stream().map(item -> (String)((AttrTO)item.getAttr((String)resourceRemoteKey.get()).get()).getValues().get(0)).collect(Collectors.toList());
        ajaxTextFieldPanel.setChoices(this.connObjectKeyFieldValues);
    }
}

