/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxWizardBuilder<T extends Serializable>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5241745929825564456L;
    protected static final Logger LOG = LoggerFactory.getLogger(AjaxWizardBuilder.class);
    protected AjaxWizard.Mode mode = AjaxWizard.Mode.CREATE;
    private final List<Component> outerObjects = new ArrayList<Component>();
    private boolean async = true;

    public AjaxWizardBuilder(T defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    public AjaxWizardBuilder<T> setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public AjaxWizardBuilder<T> addOuterObject(Component ... childs) {
        this.outerObjects.addAll(Arrays.asList(childs));
        return this;
    }

    @Override
    public AjaxWizard<T> build(String id, int index, AjaxWizard.Mode mode) {
        AjaxWizard<T> wizard = this.build(id, mode);
        for (int i = 1; i < index; ++i) {
            wizard.getWizardModel().next();
        }
        return wizard;
    }

    public AjaxWizard<T> build(AjaxWizard.Mode mode) {
        return this.build("wizard", mode);
    }

    public AjaxWizard<T> build(String id, AjaxWizard.Mode mode) {
        this.mode = mode;
        Object modelObj = this.newModelObject();
        return new AjaxWizard<T>(id, (Serializable)modelObj, this.buildModelSteps(modelObj, new WizardModel()), mode, this.async, this.pageRef, (Serializable)modelObj, mode){
            private static final long serialVersionUID = 7770507663760640735L;
            final /* synthetic */ Serializable val$modelObj;
            final /* synthetic */ AjaxWizard.Mode val$mode;
            {
                this.val$modelObj = serializable;
                this.val$mode = mode2;
                super(id, item, model, mode, async, pageRef);
            }

            @Override
            protected void onCancelInternal() {
                AjaxWizardBuilder.this.onCancelInternal(this.val$modelObj);
            }

            @Override
            protected Pair<Serializable, Serializable> onApplyInternal(AjaxRequestTarget target) {
                Serializable payload;
                Serializable res = AjaxWizardBuilder.this.onApplyInternal(this.val$modelObj);
                switch (this.val$mode) {
                    case CREATE: {
                        payload = AjaxWizardBuilder.this.getCreateCustomPayloadEvent(res, target);
                        break;
                    }
                    case EDIT: 
                    case TEMPLATE: {
                        payload = AjaxWizardBuilder.this.getEditCustomPayloadEvent(res, target);
                        break;
                    }
                    default: {
                        payload = null;
                    }
                }
                return Pair.of(payload, (Object)res);
            }
        }.setEventSink(this.eventSink).addOuterObject(this.outerObjects);
    }

    protected abstract WizardModel buildModelSteps(T var1, WizardModel var2);

    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        return null;
    }

    protected Serializable getEditCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        return null;
    }
}

