/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.reports.ReportletWrapper;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class ReportletWizardBuilder
extends AjaxWizardBuilder<ReportletWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ImplementationRestClient implementationClient = new ImplementationRestClient();
    private final ReportRestClient restClient = new ReportRestClient();
    private final String report;

    public ReportletWizardBuilder(String report, ReportletWrapper reportlet, PageReference pageRef) {
        super(reportlet, pageRef);
        this.report = report;
    }

    @Override
    protected Serializable onApplyInternal(ReportletWrapper modelObject) {
        if (modelObject.getImplementationEngine() == ImplementationEngine.JAVA) {
            BeanWrapper confWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)modelObject.getConf());
            modelObject.getSCondWrapper().forEach((fieldName, pair) -> confWrapper.setPropertyValue(fieldName, (Object)SearchUtils.buildFIQL((List)pair.getRight(), (AbstractFiqlSearchConditionBuilder)pair.getLeft())));
            ImplementationTO reportlet = this.implementationClient.read(ImplementationType.REPORTLET, modelObject.getImplementationKey());
            try {
                reportlet.setBody(MAPPER.writeValueAsString((Object)modelObject.getConf()));
                this.implementationClient.update(reportlet);
            }
            catch (Exception e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        ReportTO reportTO = this.restClient.read(this.report);
        if (modelObject.isNew()) {
            reportTO.getReportlets().add(modelObject.getImplementationKey());
        }
        this.restClient.update(reportTO);
        return modelObject;
    }

    @Override
    protected WizardModel buildModelSteps(ReportletWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        return wizardModel;
    }

    public class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Configuration(final ReportletWrapper reportlet) {
            LoadableDetachableModel<Serializable> bean = new LoadableDetachableModel<Serializable>(){
                private static final long serialVersionUID = 2092144708018739371L;

                protected Serializable load() {
                    return reportlet.getConf();
                }
            };
            this.add(new Component[]{new BeanPanel("bean", bean, reportlet.getSCondWrapper(), new String[]{"name", "reportlet"}).setRenderBodyOnly(true)});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        public Profile(final ReportletWrapper reportlet) {
            final AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("reportlet", this.getString("reportlet"), new PropertyModel((Object)reportlet, "implementationKey"));
            conf.setChoices(ReportletWizardBuilder.this.implementationClient.list(ImplementationType.REPORTLET).stream().map(EntityTO::getKey).sorted().collect(Collectors.toList()));
            conf.addRequiredLabel();
            conf.setNullValid(false);
            conf.setEnabled(reportlet.isNew());
            conf.add(new Behavior[]{new AjaxEventBehavior("change"){
                private static final long serialVersionUID = -7133385027739964990L;

                protected void onEvent(AjaxRequestTarget target) {
                    ImplementationTO impl = ReportletWizardBuilder.this.implementationClient.read(ImplementationType.REPORTLET, (String)conf.getModelObject());
                    reportlet.setImplementationEngine(impl.getEngine());
                    if (impl.getEngine() == ImplementationEngine.JAVA) {
                        try {
                            ReportletConf conf2 = (ReportletConf)MAPPER.readValue(impl.getBody(), ReportletConf.class);
                            reportlet.setConf(conf2);
                        }
                        catch (Exception e) {
                            LOG.error("During deserialization", (Throwable)e);
                        }
                    }
                }
            }});
            this.add(new Component[]{conf});
        }
    }
}

