/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.commons.ITabComponent;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.PropagationErrorPanel;
import org.apache.syncope.client.console.panels.RealmDetails;
import org.apache.syncope.client.console.panels.RealmWizardBuilder;
import org.apache.syncope.client.console.panels.RemoteObjectPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.ConnObjectPanel;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Realm
extends WizardMgtPanel<RealmTO> {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(Realm.class);
    protected final RealmTO realmTO;
    protected final List<AnyTypeTO> anyTypes;
    protected final int selectedIndex;
    protected final RealmWizardBuilder wizardBuilder;

    public Realm(String id, RealmTO realmTO, List<AnyTypeTO> anyTypes, int selectedIndex, PageReference pageRef) {
        super(id, true);
        this.realmTO = realmTO;
        this.anyTypes = anyTypes;
        this.selectedIndex = selectedIndex;
        this.setPageRef(pageRef);
        this.addInnerObject(new Component[]{new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList(pageRef)).setSelectedTab(selectedIndex)});
        this.wizardBuilder = this.buildNewItemPanelBuilder(pageRef);
        this.addNewItemPanelBuilder(this.wizardBuilder, false);
        this.setShowResultPage(true);
        this.modal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.modal);
    }

    protected RealmWizardBuilder buildNewItemPanelBuilder(PageReference pageRef) {
        return new RealmWizardBuilder(pageRef);
    }

    public RealmTO getRealmTO() {
        return this.realmTO;
    }

    protected List<ITab> buildTabList(final PageReference pageRef) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add(new RealmDetailsTabPanel());
        final AnyLayout anyLayout = AnyLayoutUtils.fetch(this.anyTypes.stream().map(AnyTypeTO::getKey).collect(Collectors.toList()));
        for (final AnyTypeTO anyType : this.anyTypes) {
            tabs.add(new ITabComponent((IModel)new ResourceModel("anyType." + anyType.getKey(), anyType.getKey()), new String[]{String.format("%s_SEARCH", anyType.getKey())}){
                private static final long serialVersionUID = 1169585538404171118L;

                @Override
                public WebMarkupContainer getPanel(String panelId) {
                    return AnyLayoutUtils.newAnyPanel(anyLayout.getAnyPanelClass(), panelId, anyType, Realm.this.realmTO, anyLayout, true, pageRef);
                }

                @Override
                public boolean isVisible() {
                    return SyncopeConsoleApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
                }
            });
        }
        return tabs;
    }

    @Override
    protected Panel customResultBody(String panelId, RealmTO item, Serializable result) {
        if (!(result instanceof ProvisioningResult)) {
            throw new IllegalStateException("Unsupported result type");
        }
        final MultilevelPanel mlp = new MultilevelPanel(panelId);
        this.add(new Component[]{mlp});
        PropagationStatus syncope = new PropagationStatus();
        syncope.setStatus(ExecStatus.SUCCESS);
        syncope.setResource("syncope");
        ArrayList<PropagationStatus> propagations = new ArrayList<PropagationStatus>();
        propagations.add(syncope);
        propagations.addAll(((ProvisioningResult)result).getPropagationStatuses());
        ListViewPanel.Builder<PropagationStatus> builder = new ListViewPanel.Builder<PropagationStatus>(PropagationStatus.class, this.pageRef){
            private static final long serialVersionUID = -6809736686861678498L;

            @Override
            protected Component getValueComponent(String key, PropagationStatus bean) {
                if ("afterObj".equalsIgnoreCase(key)) {
                    ConnObjectTO afterObj = bean.getAfterObj();
                    String remoteId = afterObj == null || afterObj.getAttrs().isEmpty() || !afterObj.getAttr("__NAME__").isPresent() || ((AttrTO)afterObj.getAttr("__NAME__").get()).getValues() == null || ((AttrTO)afterObj.getAttr("__NAME__").get()).getValues().isEmpty() ? "" : (String)((AttrTO)afterObj.getAttr("__NAME__").get()).getValues().get(0);
                    return new Label("field", (Serializable)((Object)remoteId));
                }
                if ("status".equalsIgnoreCase(key)) {
                    return StatusUtils.getStatusImagePanel("field", bean.getStatus());
                }
                return super.getValueComponent(key, bean);
            }
        };
        builder.setItems(propagations);
        builder.includes("resource", "afterObj", "status");
        builder.withChecks(ListViewPanel.CheckAvailability.NONE);
        builder.setReuseItem(false);
        builder.addAction(new ActionLink<PropagationStatus>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(PropagationStatus bean) {
                return !"syncope".equals(bean.getResource()) && (ExecStatus.CREATED == bean.getStatus() || ExecStatus.SUCCESS == bean.getStatus());
            }

            @Override
            public void onClick(AjaxRequestTarget target, PropagationStatus status) {
                mlp.next(status.getResource(), new RemoteRealmPanel(status), target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        builder.addAction(new ActionLink<PropagationStatus>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(PropagationStatus status) {
                return StringUtils.isNotBlank((CharSequence)status.getFailureReason());
            }

            @Override
            public void onClick(AjaxRequestTarget target, PropagationStatus status) {
                mlp.next(status.getResource(), new PropagationErrorPanel(status.getFailureReason()), target);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "");
        mlp.setFirstLevel(builder.build("first"));
        return mlp;
    }

    protected abstract void onClickTemplate(AjaxRequestTarget var1);

    protected abstract void onClickCreate(AjaxRequestTarget var1);

    protected abstract void onClickEdit(AjaxRequestTarget var1, RealmTO var2);

    protected abstract void onClickDelete(AjaxRequestTarget var1, RealmTO var2);

    protected class RealmDetailsTabPanel
    extends ITabComponent {
        private static final long serialVersionUID = -5861786415855103549L;

        protected RealmDetailsTabPanel() {
            super((IModel<String>)new ResourceModel("realm.details", "DETAILS"), "REALM_CREATE", "REALM_UPDATE", "REALM_DELETE");
        }

        public Panel getPanel(String panelId) {
            ActionsPanel<RealmTO> actionPanel = new ActionsPanel<RealmTO>("actions", null);
            if (StringUtils.startsWith((CharSequence)Realm.this.realmTO.getFullPath(), (CharSequence)"/")) {
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379827L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickCreate(target);
                    }
                }, ActionLink.ActionType.CREATE, "REALM_CREATE").hideLabel();
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379828L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickEdit(target, Realm.this.realmTO);
                    }
                }, ActionLink.ActionType.EDIT, "REALM_UPDATE").hideLabel();
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379827L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickTemplate(target);
                    }
                }, ActionLink.ActionType.TEMPLATE, "REALM_UPDATE").hideLabel();
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379829L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickDelete(target, Realm.this.realmTO);
                    }
                }, ActionLink.ActionType.DELETE, "REALM_DELETE", true).hideLabel();
            }
            RealmDetails panel = new RealmDetails(panelId, Realm.this.realmTO, actionPanel, false);
            panel.setContentEnabled(false);
            actionPanel.setEnabled(true);
            return panel;
        }

        @Override
        public boolean isVisible() {
            return SyncopeConsoleApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
        }
    }

    protected static class RemoteRealmPanel
    extends RemoteObjectPanel {
        private static final long serialVersionUID = 4303365227411467563L;
        protected final PropagationStatus bean;

        protected RemoteRealmPanel(PropagationStatus bean) {
            this.bean = bean;
            this.add(new Component[]{new ConnObjectPanel("remoteObject", Pair.of((Object)new ResourceModel("before"), (Object)new ResourceModel("after")), this.getConnObjectTOs(), false)});
        }

        @Override
        protected final Pair<ConnObjectTO, ConnObjectTO> getConnObjectTOs() {
            return Pair.of((Object)this.bean.getBeforeObj(), (Object)this.bean.getAfterObj());
        }
    }
}

