/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.common.rest.api.beans.RealmQuery;

public final class RealmsUtils {
    public static final int REALMS_VIEW_SIZE = 20;

    private RealmsUtils() {
    }

    public static String getFullPath(String fullpath) {
        String display = fullpath;
        if (display.indexOf(64) != -1) {
            display = StringUtils.substringBefore((String)display, (String)"@");
        }
        return display;
    }

    public static boolean isSearchEnabled() {
        return RealmsUtils.isSearchEnabled(SyncopeConsoleSession.get().getAuthRealms());
    }

    public static boolean isSearchEnabled(List<String> realms) {
        return realms.isEmpty() ? false : new RealmRestClient().search(new RealmQuery.Builder().keyword(realms.contains("/") ? "/" : realms.get(0)).build()).getTotalCount() > 20;
    }

    public static boolean checkInput(String input) {
        return StringUtils.isNotBlank((CharSequence)input) && !"*".equals(input);
    }

    public static RealmQuery buildQuery(String input) {
        return new RealmQuery.Builder().keyword(input.contains("*") ? input : "*" + input + "*").build();
    }
}

