/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.audit.AuditHistoryDetails;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.LoggerRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.common.lib.log.AuditEntry;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class AuditHistoryDirectoryPanel<T extends Serializable>
extends DirectoryPanel<AuditEntry, AuditEntry, AuditHistoryProvider, LoggerRestClient>
implements ModalPanel {
    private static final long serialVersionUID = -8248734710505211261L;
    private static final List<String> EVENTS = Arrays.asList("create", "update");
    private static final SortParam<String> REST_SORT = new SortParam((Object)"event_date", false);
    private final BaseModal<?> baseModal;
    private final MultilevelPanel mlp;
    private final AuditElements.EventCategoryType type;
    private final String category;
    private final EntityTO entity;
    private final String auditRestoreEntitlement;

    public AuditHistoryDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel mlp, AuditElements.EventCategoryType type, String category, EntityTO entity, String auditRestoreEntitlement, PageReference pageRef) {
        super("first", pageRef);
        this.disableCheckBoxes();
        this.baseModal = baseModal;
        this.mlp = mlp;
        this.type = type;
        this.category = category;
        this.entity = entity;
        this.auditRestoreEntitlement = auditRestoreEntitlement;
        this.pageRef = pageRef;
        this.restClient = new LoggerRestClient();
        this.initResultTable();
    }

    @Override
    protected AuditHistoryProvider dataProvider() {
        return new AuditHistoryProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "audit.history.paginator.rows";
    }

    @Override
    protected List<IColumn<AuditEntry, String>> getColumns() {
        ArrayList<IColumn<AuditEntry, String>> columns = new ArrayList<IColumn<AuditEntry, String>>();
        columns.add((IColumn<AuditEntry, String>)new PropertyColumn((IModel)new StringResourceModel("who", (Component)this), "who"));
        columns.add((IColumn<AuditEntry, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("date", (Component)this), null, "date"));
        return columns;
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<AuditEntry, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.mlp);
    }

    protected abstract void restore(String var1, AjaxRequestTarget var2);

    @Override
    protected ActionsPanel<AuditEntry> getActions(IModel<AuditEntry> model) {
        ActionsPanel<AuditEntry> panel = super.getActions(model);
        panel.add(new ActionLink<AuditEntry>(){
            private static final long serialVersionUID = -6745431735457245600L;

            @Override
            public void onClick(AjaxRequestTarget target, AuditEntry modelObject) {
                AuditHistoryDirectoryPanel.this.getTogglePanel().close(target);
                AuditHistoryDirectoryPanel.this.mlp.next((String)new StringResourceModel("audit.diff.view", (Component)AuditHistoryDirectoryPanel.this).getObject(), new AuditHistoryDetails<T>(AuditHistoryDirectoryPanel.this.mlp, modelObject, AuditHistoryDirectoryPanel.this.entity, AuditHistoryDirectoryPanel.this.auditRestoreEntitlement, AuditHistoryDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -5311898419151367494L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        AuditHistoryDirectoryPanel.this.restore(json, target);
                    }
                }, target);
                target.add(new Component[]{AuditHistoryDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.VIEW, "AUDIT_READ");
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    protected class AuditHistoryProvider
    extends DirectoryDataProvider<AuditEntry> {
        private static final long serialVersionUID = 415113175628260864L;

        AuditHistoryProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("date", SortOrder.DESCENDING);
        }

        public long size() {
            return ((LoggerRestClient)AuditHistoryDirectoryPanel.this.restClient).count(AuditHistoryDirectoryPanel.this.entity.getKey(), AuditHistoryDirectoryPanel.this.type, AuditHistoryDirectoryPanel.this.category, EVENTS, AuditElements.Result.SUCCESS);
        }

        public Iterator<AuditEntry> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((LoggerRestClient)AuditHistoryDirectoryPanel.this.restClient).search(AuditHistoryDirectoryPanel.this.entity.getKey(), (page < 0 ? 0 : page) + 1, this.paginatorRows, AuditHistoryDirectoryPanel.this.type, AuditHistoryDirectoryPanel.this.category, EVENTS, AuditElements.Result.SUCCESS, (SortParam<String>)REST_SORT).iterator();
        }

        public IModel<AuditEntry> model(AuditEntry auditEntryBean) {
            return new CompoundPropertyModel((Object)auditEntryBean);
        }
    }
}

