/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import java.security.AccessControlException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeConsoleRequestCycleListener
implements IRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeConsoleRequestCycleListener.class);

    private Throwable instanceOf(Exception e, Class<? extends Exception> clazz) {
        return clazz.isAssignableFrom(e.getClass()) ? e : (e.getCause() != null && clazz.isAssignableFrom(e.getCause().getClass()) ? e.getCause() : (e.getCause() != null && e.getCause().getCause() != null && clazz.isAssignableFrom(e.getCause().getCause().getClass()) ? e.getCause().getCause() : null));
    }

    public IRequestHandler onException(RequestCycle cycle, Exception e) {
        Login errorPage;
        LOG.error("Exception found", (Throwable)e);
        PageParameters errorParameters = new PageParameters();
        if (this.instanceOf(e, UnauthorizedInstantiationException.class) != null) {
            errorParameters.add("errorMessage", (Object)SyncopeConsoleSession.Error.AUTHORIZATION.fallback());
            errorPage = new Login(errorParameters);
        } else if (this.instanceOf(e, AccessControlException.class) != null) {
            if (StringUtils.containsIgnoreCase((CharSequence)this.instanceOf(e, AccessControlException.class).getMessage(), (CharSequence)"expired")) {
                errorParameters.add("errorMessage", (Object)SyncopeConsoleSession.Error.SESSION_EXPIRED.fallback());
            } else {
                errorParameters.add("errorMessage", (Object)SyncopeConsoleSession.Error.AUTHORIZATION.fallback());
            }
            errorPage = new Login(errorParameters);
        } else if (this.instanceOf(e, PageExpiredException.class) != null || !SyncopeConsoleSession.get().isSignedIn()) {
            errorParameters.add("errorMessage", (Object)SyncopeConsoleSession.Error.SESSION_EXPIRED.fallback());
            errorPage = new Login(errorParameters);
        } else if (this.instanceOf(e, BadRequestException.class) != null || this.instanceOf(e, WebServiceException.class) != null || this.instanceOf(e, SyncopeClientException.class) != null) {
            errorParameters.add("errorMessage", (Object)SyncopeConsoleSession.Error.REST.fallback());
            errorPage = new Login(errorParameters);
        } else {
            Throwable cause = this.instanceOf(e, ForbiddenException.class);
            if (cause == null) {
                errorPage = new ExceptionErrorPage((Throwable)e, null);
            } else {
                errorParameters.add("errorMessage", (Object)cause.getMessage());
                errorPage = new Login(errorParameters);
            }
        }
        if (errorPage instanceof Login) {
            try {
                SyncopeConsoleSession.get().invalidate();
            }
            catch (Throwable t) {
                LOG.debug("Unexpected error while forcing logout after error", t);
            }
        }
        return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)errorPage));
    }
}

