/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result.xslt;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.result.xslt.AdapterFactory;
import org.apache.struts2.result.xslt.ServletURIResolver;

public class XSLTResult
implements Result {
    private static final long serialVersionUID = 6424691441777176763L;
    private static final Logger LOG = LogManager.getLogger(XSLTResult.class);
    public static final String DEFAULT_PARAM = "stylesheetLocation";
    private static final Map<String, Templates> templatesCache = new HashMap<String, Templates>();
    protected boolean noCache;
    private String stylesheetLocation;
    private String exposedValue;
    private int status = 200;
    private String encoding = "UTF-8";
    private boolean parse;
    private transient AdapterFactory adapterFactory;

    public XSLTResult() {
    }

    public XSLTResult(String stylesheetLocation) {
        this();
        this.setStylesheetLocation(stylesheetLocation);
    }

    @Inject(value="struts.xslt.nocache")
    public void setNoCache(String xsltNoCache) {
        this.noCache = BooleanUtils.toBoolean((String)xsltNoCache);
    }

    public void setStylesheetLocation(String location) {
        this.stylesheetLocation = location;
    }

    public String getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public String getExposedValue() {
        return this.exposedValue;
    }

    public void setExposedValue(String exposedValue) {
        this.exposedValue = exposedValue;
    }

    public String getStatus() {
        return String.valueOf(this.status);
    }

    public void setStatus(String status) {
        try {
            this.status = Integer.parseInt(status);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Status value not number " + e.getMessage(), e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        if (invocation == null) {
            throw new IllegalArgumentException("Invocation cannot be null!");
        }
        long startTime = System.currentTimeMillis();
        String location = this.getStylesheetLocation();
        if (location == null) {
            throw new IllegalArgumentException("Parameter 'stylesheetLocation' cannot be null!");
        }
        if (this.parse) {
            ValueStack stack = invocation.getStack();
            location = TextParseUtil.translateVariables((String)location, (ValueStack)stack);
        }
        try {
            Transformer transformer;
            HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
            response.setStatus(this.status);
            response.setCharacterEncoding(this.encoding);
            PrintWriter writer = response.getWriter();
            Templates templates = null;
            if (location != null) {
                templates = this.getTemplates(location);
                transformer = templates.newTransformer();
            } else {
                TransformerFactory factory = this.createTransformerFactory();
                transformer = factory.newTransformer();
            }
            transformer.setURIResolver(this.getURIResolver());
            transformer.setErrorListener(this.buildErrorListener());
            String mimeType = templates == null ? "text/xml" : templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            Object result = invocation.getAction();
            if (this.exposedValue != null) {
                ValueStack stack = invocation.getStack();
                result = stack.findValue(this.exposedValue);
            }
            Source xmlSource = this.getDOMSourceForStack(result);
            LOG.debug("xmlSource = {}", (Object)xmlSource);
            transformer.transform(xmlSource, new StreamResult(writer));
            writer.flush();
            LOG.debug("Time: {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            LOG.error("Unable to render XSLT Template, '{}'", (Object)location, (Object)e);
            throw e;
        }
    }

    protected TransformerFactory createTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        LOG.debug("Disables parsing external entities");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }

    protected ErrorListener buildErrorListener() {
        return new ErrorListener(){

            @Override
            public void error(TransformerException exception) throws TransformerException {
                throw new StrutsException("Error transforming result", (Throwable)exception);
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                throw new StrutsException("Fatal error transforming result", (Throwable)exception);
            }

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                LOG.warn(exception.getMessage(), (Throwable)exception);
            }
        };
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new AdapterFactory();
        }
        return this.adapterFactory;
    }

    protected void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    protected URIResolver getURIResolver() {
        return new ServletURIResolver(ServletActionContext.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String path) throws TransformerException, IOException {
        if (path == null) {
            throw new TransformerException("Stylesheet path is null");
        }
        Templates templates = templatesCache.get(path);
        if (this.noCache || templates == null) {
            Map<String, Templates> map = templatesCache;
            synchronized (map) {
                URL resource = ServletActionContext.getServletContext().getResource(path);
                if (resource == null) {
                    throw new TransformerException("Stylesheet " + path + " not found in resources.");
                }
                LOG.debug("Preparing XSLT stylesheet templates: {}", (Object)path);
                TransformerFactory factory = this.createTransformerFactory();
                factory.setURIResolver(this.getURIResolver());
                factory.setErrorListener(this.buildErrorListener());
                templates = factory.newTemplates(new StreamSource(resource.openStream()));
                templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    protected Source getDOMSourceForStack(Object value) {
        return new DOMSource(this.getAdapterFactory().adaptDocument("result", value));
    }
}

