/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;

public class ReadWriteLDAPUserStoreConstants {
    public static final ArrayList<Property> RWLDAP_USERSTORE_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> OPTINAL_RWLDAP_USERSTORE_PROPERTIES = new ArrayList();

    private static void setMandatoryProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        RWLDAP_USERSTORE_PROPERTIES.add(property);
    }

    private static void setProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        OPTINAL_RWLDAP_USERSTORE_PROPERTIES.add(property);
    }

    static {
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("ConnectionName", "uid=,ou=", "This should be the DN (Distinguish Name) of the admin user in LDAP");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("ConnectionURL", "ldap://", "Connection URL for the user store");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("ConnectionPassword", "", "Password of the admin user");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("UserSearchBase", "ou=Users,dc=wso2,dc=org", "DN of the context under which user entries are stored in LDAP");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("Disabled", "false", "Whether user store is disabled");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("UserNameListFilter", "(objectClass=person)", "Filtering criteria for listing all the user entries in LDAP");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("UserNameAttribute", "uid", "Attribute used for uniquely identifying a user entry. Users can be authenticated using their email address, uid and etc");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("UserNameSearchFilter", "(&amp;(objectClass=person)(uid=?))", "Filtering criteria for searching a particular user entry");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("UserEntryObjectClass", "wso2Person", "Object Class used to construct user entries");
        ReadWriteLDAPUserStoreConstants.setMandatoryProperty("GroupEntryObjectClass", "groupOfNames", "Object Class used to construct group entries");
        ReadWriteLDAPUserStoreConstants.setProperty("MaxUserNameListLength", "100", "Maximum number of users retrieved at once");
        ReadWriteLDAPUserStoreConstants.setProperty("MaxRoleNameListLength", "100", "Maximum number of roles retrieved at once");
        ReadWriteLDAPUserStoreConstants.setProperty("UserRolesCacheEnabled", "true", "This is to indicate whether to cache the role list of a user");
        ReadWriteLDAPUserStoreConstants.setProperty("SCIMEnabled", "false", "Whether SCIM is enabled for the user store");
        Property readLDAPGroups = new Property("ReadGroups", "true", "Specifies whether groups should be read from LDAP", null);
        Property groupSearchBase = new Property("GroupSearchBase", "ou=Groups,dc=wso2,dc=org", "DN of the context under which user entries are stored in LDAP", null);
        Property groupNameListFilter = new Property("GroupNameListFilter", "(objectClass=groupOfNames)", "Filtering criteria for listing all the group entries in LDAP", null);
        Property groupNameAttribute = new Property("GroupNameAttribute", "cn", "Attribute used for uniquely identifying a user entry", null);
        Property membershipAttribute = new Property("MembershipAttribute", "member", "Attribute used to define members of LDAP groups", null);
        Property groupNameSearchFilter = new Property("GroupNameSearchFilter", "(&amp;(objectClass=groupOfNames)(cn=?))", "Filtering criteria for searching a particular group entry", null);
        RWLDAP_USERSTORE_PROPERTIES.add(readLDAPGroups);
        RWLDAP_USERSTORE_PROPERTIES.add(groupSearchBase);
        RWLDAP_USERSTORE_PROPERTIES.add(groupNameAttribute);
        RWLDAP_USERSTORE_PROPERTIES.add(groupNameListFilter);
        RWLDAP_USERSTORE_PROPERTIES.add(membershipAttribute);
        RWLDAP_USERSTORE_PROPERTIES.add(groupNameSearchFilter);
        ReadWriteLDAPUserStoreConstants.setProperty("PasswordHashMethod", "SHA", "Password Hash method to use when storing user entries");
        ReadWriteLDAPUserStoreConstants.setProperty("UserDNPattern", "uid={0},ou=Users,dc=wso2,dc=org", "The patten for user's DN. It can be defined to improve the LDAP search");
        ReadWriteLDAPUserStoreConstants.setProperty("PasswordJavaScriptRegEx", "^[\\S]{5,30}$", "Policy that defines the password format");
        ReadWriteLDAPUserStoreConstants.setProperty("UserNameJavaScriptRegEx", "^[\\S]{3,30}$", "A regular expression to validate user names");
        ReadWriteLDAPUserStoreConstants.setProperty("UserNameJavaRegEx", "[a-zA-Z0-9._-|//]{3,30}$", "A regular expression to validate user names");
        ReadWriteLDAPUserStoreConstants.setProperty("RoleNameJavaScriptRegEx", "^[\\S]{3,30}$", "The regular expression used by the front-end components for role name validation");
        ReadWriteLDAPUserStoreConstants.setProperty("RoleNameJavaRegEx", "[a-zA-Z0-9._-|//]{3,30}$", "A regular expression to validate role names");
        ReadWriteLDAPUserStoreConstants.setProperty("WriteGroups", "true", "Indicate whether write groups enabled");
        ReadWriteLDAPUserStoreConstants.setProperty("EmptyRolesAllowed", "true", "Specifies whether the underlying user store allows empty roles to be added");
    }
}

