/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.io.Serializable;

public class AuthorizationKey
implements Serializable {
    private static final long serialVersionUID = 926710669453381695L;
    private String userName;
    private String resourceId;
    private String action;
    private int tenantId;
    private String serverId;

    public AuthorizationKey(String serverId, int tenantId, String userName, String resourceId, String action) {
        this.userName = userName;
        this.resourceId = resourceId;
        this.action = action;
        this.tenantId = tenantId;
        this.serverId = serverId;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof AuthorizationKey)) {
            return false;
        }
        AuthorizationKey secondObject = (AuthorizationKey)otherObject;
        return this.checkAttributesAreEqual(this.serverId, this.tenantId, this.userName, this.resourceId, this.action, secondObject);
    }

    public int hashCode() {
        return this.getHashCodeForAttributes(this.serverId, this.tenantId, this.userName, this.resourceId, this.action);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getAction() {
        return this.action;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public String getServerId() {
        return this.serverId;
    }

    private int getHashCodeForAttributes(String severId, int tenantId, String userName, String resourceId, String action) {
        if (tenantId != -1 && userName != null && severId != null) {
            if (tenantId == -1234) {
                tenantId = 0;
            }
            return tenantId + userName.hashCode() * 5 + severId.hashCode() * 7 + resourceId.hashCode() * 11 + action.hashCode() * 13;
        }
        if (severId != null) {
            return severId.hashCode() * 7 + resourceId.hashCode() * 11 + action.hashCode() * 11;
        }
        return resourceId.hashCode() * 11 + action.hashCode() * 13;
    }

    private boolean checkAttributesAreEqual(String serverId, int tenantId, String userName, String resourceIdentifier, String actionName, AuthorizationKey authorizationKey) {
        boolean equality;
        boolean bl = equality = tenantId == authorizationKey.getTenantId() && userName.equals(authorizationKey.getUserName()) && resourceIdentifier.equals(authorizationKey.getResourceId()) && actionName.equals(authorizationKey.getAction());
        if (serverId != null) {
            equality = equality && serverId.equals(authorizationKey.getServerId());
        }
        return equality;
    }
}

