/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.event.receivers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.domain.mapping.DomainMappingAddedEvent;
import org.apache.stratos.messaging.event.domain.mapping.DomainMappingRemovedEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.domain.mapping.DomainMappingAddedEventListener;
import org.apache.stratos.messaging.listener.domain.mapping.DomainMappingRemovedEventListener;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventReceiver;

public class LoadBalancerCommonDomainMappingEventReceiver {
    private static final Log log = LogFactory.getLog(LoadBalancerCommonDomainMappingEventReceiver.class);
    private TopologyProvider topologyProvider;
    private DomainMappingEventReceiver domainMappingEventReceiver;

    public LoadBalancerCommonDomainMappingEventReceiver(TopologyProvider topologyProvider) {
        this.domainMappingEventReceiver = DomainMappingEventReceiver.getInstance();
        this.topologyProvider = topologyProvider;
        this.addEventListeners();
    }

    public LoadBalancerCommonDomainMappingEventReceiver(TopologyProvider topologyProvider, boolean addListeners) {
        this.topologyProvider = topologyProvider;
        if (addListeners) {
            this.addEventListeners();
        }
    }

    public void addEventListeners() {
        this.domainMappingEventReceiver.addEventListener((EventListener)new DomainMappingAddedEventListener(){

            protected void onEvent(Event event) {
                DomainMappingAddedEvent domainMappingAddedEvent = (DomainMappingAddedEvent)event;
                String domainName = domainMappingAddedEvent.getDomainName();
                String contextPath = domainMappingAddedEvent.getContextPath();
                String clusterId = domainMappingAddedEvent.getClusterId();
                Cluster cluster = LoadBalancerCommonDomainMappingEventReceiver.this.topologyProvider.getClusterByClusterId(clusterId);
                if (cluster == null) {
                    log.warn((Object)String.format("Could not add domain mapping, cluster not found: [cluster] %s", clusterId));
                }
                LoadBalancerCommonDomainMappingEventReceiver.this.addDomainMapping(cluster, domainName, contextPath);
            }
        });
        this.domainMappingEventReceiver.addEventListener((EventListener)new DomainMappingRemovedEventListener(){

            protected void onEvent(Event event) {
                DomainMappingRemovedEvent domainMappingRemovedEvent = (DomainMappingRemovedEvent)event;
                String clusterId = domainMappingRemovedEvent.getClusterId();
                Cluster cluster = LoadBalancerCommonDomainMappingEventReceiver.this.topologyProvider.getClusterByClusterId(clusterId);
                if (cluster == null) {
                    log.warn((Object)String.format("Could not remove domain mapping, cluster not found: [cluster] %s", clusterId));
                }
                String domainName = domainMappingRemovedEvent.getDomainName();
                LoadBalancerCommonDomainMappingEventReceiver.this.removeDomainMapping(cluster, domainName);
            }
        });
    }

    protected void addDomainMapping(Cluster cluster, String domainName, String contextPath) {
        cluster.addHostName(domainName, contextPath);
        log.info((Object)String.format("Domain mapping added: [cluster] %s [domain] %s [context-path]", cluster.getClusterId(), domainName));
    }

    protected void removeDomainMapping(Cluster cluster, String domainName) {
        cluster.removeHostName(domainName);
        log.info((Object)String.format("Domain mapping removed: [cluster] %s [domain] %s", cluster.getClusterId(), domainName));
    }
}

