/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceProvider;
import org.apache.axis2.java.security.AccessController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassUtils {
    private static Log log = LogFactory.getLog(ClassUtils.class);
    private static HashMap loadClassMap = new HashMap();
    private static HashMap loadableMap;
    private static final Class[] noClass;

    public static Throwable getRootCause(Throwable e) {
        Throwable t = null;
        if (e != null && (t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : null) != null) {
            e = ClassUtils.getRootCause(t);
        }
        return e;
    }

    public static String getLoadableClassName(String text) {
        String loadClass;
        int bracket = text.indexOf("[");
        String className = text;
        if (bracket > 0) {
            className = className.substring(0, bracket);
        }
        if ((loadClass = (String)loadableMap.get(className)) == null) {
            loadClass = "L" + className + ";";
        }
        if (bracket > 0) {
            int i = text.indexOf("]");
            while (i > 0) {
                loadClass = "[" + loadClass;
                i = text.indexOf("]", i + 1);
            }
        }
        return loadClass;
    }

    public static String getTextClassName(String text) {
        int index;
        if (text == null || text.indexOf("[") != 0) {
            return text;
        }
        String className = "";
        for (index = 0; index < text.length() && text.charAt(index) == '['; ++index) {
            className = className + "[]";
        }
        if (index < text.length()) {
            className = text.charAt(index) == 'B' ? "byte" + className : (text.charAt(index) == 'C' ? "char" + className : (text.charAt(index) == 'D' ? "double" + className : (text.charAt(index) == 'F' ? "float" + className : (text.charAt(index) == 'I' ? "int" + className : (text.charAt(index) == 'J' ? "long" + className : (text.charAt(index) == 'S' ? "short" + className : (text.charAt(index) == 'Z' ? "boolean" + className : (text.equals("void") ? "void" : text.substring(index + 1, text.indexOf(";")) + className))))))));
        }
        return className;
    }

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static Class getPrimitiveClass(Class wrapper) {
        if (wrapper == Integer.class) {
            return Integer.TYPE;
        }
        if (wrapper == Short.class) {
            return Short.TYPE;
        }
        if (wrapper == Boolean.class) {
            return Boolean.TYPE;
        }
        if (wrapper == Byte.class) {
            return Byte.TYPE;
        }
        if (wrapper == Long.class) {
            return Long.TYPE;
        }
        if (wrapper == Double.class) {
            return Double.TYPE;
        }
        if (wrapper == Float.class) {
            return Float.TYPE;
        }
        if (wrapper == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Constructor getDefaultPublicConstructor(Class clazz) {
        try {
            return clazz.getConstructor(noClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class getPrimitiveClass(String text) {
        return (Class)loadClassMap.get(text);
    }

    public static final boolean isJAXWSClass(Class cls) {
        String className;
        WebService wsAnn = (WebService)ClassUtils.getAnnotation(cls, WebService.class);
        if (wsAnn != null) {
            return true;
        }
        WebServiceClient wscAnn = (WebServiceClient)ClassUtils.getAnnotation(cls, WebServiceClient.class);
        if (wscAnn != null) {
            return true;
        }
        WebServiceProvider wspAnn = (WebServiceProvider)ClassUtils.getAnnotation(cls, WebServiceProvider.class);
        if (wspAnn != null) {
            return true;
        }
        WebFault wfAnn = (WebFault)ClassUtils.getAnnotation(cls, WebFault.class);
        if (wfAnn != null) {
            return true;
        }
        if (Holder.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Service.class.isAssignableFrom(cls)) {
            return true;
        }
        String string = className = cls.getPackage() == null ? null : cls.getPackage().getName();
        return className != null && className.startsWith("javax.xml.ws") && !className.startsWith("javax.xml.ws.wsaddressing");
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation);
            }
        });
    }

    public static Set<Class> getClasses(Type type, Set<Class> list) {
        block8: {
            if (list == null) {
                list = new HashSet<Class>();
            }
            try {
                if (type instanceof Class) {
                    list.add((Class)type);
                }
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    ClassUtils.getClasses(pt.getRawType(), list);
                    Type[] types = pt.getActualTypeArguments();
                    if (types != null) {
                        for (int i = 0; i < types.length; ++i) {
                            ClassUtils.getClasses(types[i], list);
                        }
                    }
                }
                if (type instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)type;
                    ClassUtils.getClasses(gat.getGenericComponentType(), list);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("Problem occurred in getClasses. Processing continues " + t));
            }
        }
        return list;
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
        loadableMap = new HashMap();
        loadableMap.put("byte", "B");
        loadableMap.put("char", "C");
        loadableMap.put("double", "D");
        loadableMap.put("float", "F");
        loadableMap.put("int", "I");
        loadableMap.put("long", "J");
        loadableMap.put("short", "S");
        loadableMap.put("boolean", "Z");
        noClass = new Class[0];
    }
}

