/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.internal;

import com.hazelcast.core.HazelcastInstance;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.clustering.impl.HazelcastDistributedObjectProvider;
import org.apache.stratos.common.internal.ComponentStartUpSynchronizerImpl;
import org.apache.stratos.common.internal.ServiceReferenceHolder;
import org.apache.stratos.common.services.ComponentStartUpSynchronizer;
import org.apache.stratos.common.services.DistributedObjectProvider;
import org.apache.stratos.common.threading.StratosThreadPool;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.common.util.StratosConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CommonServiceComponent {
    private static Log log = LogFactory.getLog(CommonServiceComponent.class);

    protected void activate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activating CommonServiceComponent...");
        }
        try {
            AxisConfiguration axisConfig;
            final BundleContext bundleContext = context.getBundleContext();
            if (CommonUtil.getStratosConfig() == null) {
                StratosConfiguration stratosConfig = CommonUtil.loadStratosConfiguration();
                CommonUtil.setStratosConfig(stratosConfig);
            }
            if (CommonUtil.getEula() == null) {
                String eula = CommonUtil.loadTermsOfUsage();
                CommonUtil.setEula(eula);
            }
            if ((axisConfig = ServiceReferenceHolder.getInstance().getAxisConfiguration()) != null && axisConfig.getClusteringAgent() != null) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            log.info((Object)"Waiting for the hazelcast instance to be initialized...");
                            while (ServiceReferenceHolder.getInstance().getHazelcastInstance() == null) {
                                log.info((Object)"Waiting for Hazelcast instance to be initialized...");
                                Thread.sleep(1000L);
                                if (System.currentTimeMillis() - startTime < 300000L) continue;
                                throw new RuntimeException("Hazelcast instance was not initialized within 300 seconds");
                            }
                            CommonServiceComponent.this.registerDistributedObjectProviderService(bundleContext);
                            CommonServiceComponent.this.registerComponentStartUpSynchronizer(bundleContext);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                };
                thread.setName("Distributed object provider registration thread");
                thread.start();
            } else {
                this.registerDistributedObjectProviderService(bundleContext);
                this.registerComponentStartUpSynchronizer(bundleContext);
            }
            try {
                StratosConfiguration stratosConfiguration = CommonUtil.loadStratosConfiguration();
                bundleContext.registerService(StratosConfiguration.class.getName(), (Object)stratosConfiguration, null);
            }
            catch (Exception ex) {
                String msg = "An error occurred while registering stratos configuration service";
                log.error((Object)msg, (Throwable)ex);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Stratos common service component is activated");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in activating stratos common service component", (Throwable)e);
        }
    }

    private void registerDistributedObjectProviderService(BundleContext bundleContext) {
        HazelcastDistributedObjectProvider distributedObjectProvider = new HazelcastDistributedObjectProvider();
        ServiceReferenceHolder.getInstance().setDistributedObjectProvider(distributedObjectProvider);
        bundleContext.registerService(DistributedObjectProvider.class, (Object)distributedObjectProvider, null);
    }

    private void registerComponentStartUpSynchronizer(BundleContext bundleContext) {
        ComponentStartUpSynchronizerImpl componentStartUpSynchronizer = new ComponentStartUpSynchronizerImpl(ServiceReferenceHolder.getInstance().getDistributedObjectProvider());
        bundleContext.registerService(ComponentStartUpSynchronizer.class, (Object)componentStartUpSynchronizer, null);
    }

    protected void deactivate(ComponentContext context) {
        try {
            StratosThreadPool.shutDownAllThreadPoolsGracefully();
            StratosThreadPool.shutDownAllScheduledExecutorsGracefully();
            log.debug((Object)"Stratos common service component is de-activated");
        }
        catch (Exception e) {
            log.error((Object)"Could not de-activate Stratos common service component", (Throwable)e);
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        ServiceReferenceHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        ServiceReferenceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ServiceReferenceHolder.getInstance().setRealmService(null);
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        ServiceReferenceHolder.getInstance().setHazelcastInstance(hazelcastInstance);
    }

    public void unsetHazelcastInstance(HazelcastInstance hazelcastInstance) {
        ServiceReferenceHolder.getInstance().setHazelcastInstance(null);
    }

    protected void setDistributedMapProvider(DistributedMapProvider mapProvider) {
        ServiceReferenceHolder.getInstance().setDistributedMapProvider(mapProvider);
    }

    protected void unsetDistributedMapProvider(DistributedMapProvider mapProvider) {
        ServiceReferenceHolder.getInstance().setDistributedMapProvider(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ServiceReferenceHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ServiceReferenceHolder.getInstance().setAxisConfiguration(null);
    }
}

