/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.concurrent.locks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.concurrent.locks.LockMetadata;
import org.apache.stratos.common.concurrent.locks.LockType;
import org.apache.stratos.common.concurrent.locks.ReadWriteLockMonitor;
import org.apache.stratos.common.exception.InvalidLockRequestedException;
import org.apache.stratos.common.threading.StratosThreadPool;

public class ReadWriteLock {
    private static final Log log = LogFactory.getLog(ReadWriteLock.class);
    private static final String READ_WRITE_LOCK_MONITOR_THREAD_POOL = "read.write.lock.monitor.thread.pool";
    private static final String READ_WRITE_LOCK_MONITOR_THREAD_POOL_SIZE_KEY = "read.write.lock.monitor.thread.pool.size";
    private final String name;
    private final ReentrantReadWriteLock lock;
    private final Map<Long, Map<LockType, LockMetadata>> threadToLockSetMap;
    private boolean readWriteLockMonitorEnabled;
    private int readWriteLockMonitorInterval;
    private int threadPoolSize;

    public ReadWriteLock(String name) {
        this.name = name;
        this.lock = new ReentrantReadWriteLock(true);
        this.threadToLockSetMap = new ConcurrentHashMap<Long, Map<LockType, LockMetadata>>();
        this.readWriteLockMonitorEnabled = Boolean.getBoolean("read.write.lock.monitor.enabled");
        if (this.readWriteLockMonitorEnabled) {
            this.readWriteLockMonitorInterval = Integer.getInteger("read.write.lock.monitor.interval", 30000);
            this.threadPoolSize = Integer.getInteger(READ_WRITE_LOCK_MONITOR_THREAD_POOL_SIZE_KEY, 10);
            ScheduledThreadPoolExecutor scheduledExecutor = StratosThreadPool.getScheduledExecutorService(READ_WRITE_LOCK_MONITOR_THREAD_POOL, this.threadPoolSize);
            scheduledExecutor.scheduleAtFixedRate(new ReadWriteLockMonitor(this), this.readWriteLockMonitorInterval, this.readWriteLockMonitorInterval, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Lock monitor scheduled: [lock-name] %s [interval] %d seconds", name, this.readWriteLockMonitorInterval / 1000));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    Map<Long, Map<LockType, LockMetadata>> getThreadToLockSetMap() {
        return this.threadToLockSetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<LockType, LockMetadata> getLockTypeLongMap(long threadId) {
        Map<LockType, LockMetadata> lockTypeLongMap = this.threadToLockSetMap.get(threadId);
        if (lockTypeLongMap != null) return lockTypeLongMap;
        Class<ReadWriteLock> clazz = ReadWriteLock.class;
        synchronized (ReadWriteLock.class) {
            if (lockTypeLongMap != null) return lockTypeLongMap;
            lockTypeLongMap = new HashMap<LockType, LockMetadata>();
            this.threadToLockSetMap.put(threadId, lockTypeLongMap);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return lockTypeLongMap;
        }
    }

    public void acquireWriteLock() {
        Map<LockType, LockMetadata> lockTypeLongMap;
        Thread currentThread = Thread.currentThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Acquiring write lock: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
        if (this.readWriteLockMonitorEnabled && (lockTypeLongMap = this.getLockTypeLongMap(currentThread.getId())).containsKey((Object)LockType.Read)) {
            String message = String.format("System error, cannot acquire a write lock while having a read lock on the same thread: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName());
            InvalidLockRequestedException exception = new InvalidLockRequestedException(message);
            log.error((Object)exception);
            throw exception;
        }
        this.lock.writeLock().lock();
        if (this.readWriteLockMonitorEnabled) {
            LockMetadata lockMetadata = new LockMetadata(this.getName(), LockType.Write, currentThread.getId(), currentThread.getName(), currentThread.getStackTrace(), System.currentTimeMillis());
            Map<LockType, LockMetadata> lockTypeLongMap2 = this.getLockTypeLongMap(currentThread.getId());
            lockTypeLongMap2.put(lockMetadata.getLockType(), lockMetadata);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write lock acquired: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
    }

    public void releaseWriteLock() {
        Thread currentThread = Thread.currentThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Releasing write lock: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.writeLock().unlock();
            if (this.readWriteLockMonitorEnabled) {
                Map<LockType, LockMetadata> lockTypeLongMap = this.getLockTypeLongMap(currentThread.getId());
                lockTypeLongMap.remove((Object)LockType.Write);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Write lock released: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
            }
        } else {
            log.warn((Object)String.format("System warning! Trying to release a lock which has not been taken by the same thread: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
    }

    public void acquireReadLock() {
        Thread currentThread = Thread.currentThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Acquiring read lock: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
        this.lock.readLock().lock();
        if (this.readWriteLockMonitorEnabled) {
            Map<LockType, LockMetadata> lockTypeLongMap = this.getLockTypeLongMap(currentThread.getId());
            LockMetadata lockMetadata = new LockMetadata(this.getName(), LockType.Read, currentThread.getId(), currentThread.getName(), currentThread.getStackTrace(), System.currentTimeMillis());
            lockTypeLongMap.put(lockMetadata.getLockType(), lockMetadata);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Read lock acquired: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
    }

    public void releaseReadLock() {
        Thread currentThread = Thread.currentThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Releasing read lock: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
        this.lock.readLock().unlock();
        if (this.readWriteLockMonitorEnabled) {
            Map<LockType, LockMetadata> lockTypeLongMap = this.getLockTypeLongMap(currentThread.getId());
            lockTypeLongMap.remove((Object)LockType.Read);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Read lock released: [lock-name] %s [thread-id] %d [thread-name] %s", this.getName(), currentThread.getId(), currentThread.getName()));
        }
    }
}

