/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.clustering.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.clustering.impl.ListEntryListener;

public class HazelcastDistributedListProvider
implements Serializable {
    private static final Log log = LogFactory.getLog(HazelcastDistributedListProvider.class);
    private HazelcastInstance hazelcastInstance;
    private Map<String, DistList> listMap;

    public HazelcastDistributedListProvider(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getList(String name, ListEntryListener listEntryListener) {
        List list = this.listMap.get(name);
        if (list != null) return list;
        Class<HazelcastDistributedListProvider> clazz = HazelcastDistributedListProvider.class;
        synchronized (HazelcastDistributedListProvider.class) {
            if (list != null) return list;
            return new DistList(name, listEntryListener);
        }
    }

    public void removeList(String name) {
        DistList list = this.listMap.get(name);
        if (list != null) {
            IList ilist = (IList)list;
            ilist.removeItemListener(list.getListenerId());
            this.listMap.remove(list);
            ilist.destroy();
        }
    }

    private class DistList
    implements List {
        private IList list;
        private String listenerId;

        public DistList(String name, final ListEntryListener listEntryListener) {
            this.list = HazelcastDistributedListProvider.this.hazelcastInstance.getList(name);
            this.listenerId = this.list.addItemListener(new ItemListener(){

                public void itemAdded(ItemEvent itemEvent) {
                    listEntryListener.itemAdded(itemEvent.getItem());
                }

                public void itemRemoved(ItemEvent itemEvent) {
                    listEntryListener.itemRemoved(itemEvent.getItem());
                }
            }, false);
        }

        @Override
        public int size() {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.size();
            }
            return 0;
        }

        @Override
        public boolean isEmpty() {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.isEmpty();
            }
            return true;
        }

        @Override
        public boolean contains(Object object) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.contains(object);
            }
            return false;
        }

        @Override
        public Iterator iterator() {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.iterator();
            }
            return null;
        }

        @Override
        public Object[] toArray() {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.toArray();
            }
            return new Object[0];
        }

        @Override
        public boolean add(Object object) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.add(object);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.remove(object);
            }
            return false;
        }

        @Override
        public boolean addAll(Collection collection) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.addAll(collection);
            }
            return false;
        }

        public boolean addAll(int i, Collection collection) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.addAll(i, collection);
            }
            return false;
        }

        @Override
        public void clear() {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                this.list.clear();
            }
        }

        public Object get(int i) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.get(i);
            }
            return null;
        }

        public Object set(int i, Object o) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.set(i, o);
            }
            return null;
        }

        public void add(int i, Object o) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                this.list.add(i, o);
            }
        }

        public Object remove(int i) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.remove(i);
            }
            return null;
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.lastIndexOf(o);
            }
            return -1;
        }

        public ListIterator listIterator() {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.listIterator();
            }
            return null;
        }

        public ListIterator listIterator(int i) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.listIterator(i);
            }
            return null;
        }

        public List subList(int i, int i2) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.subList(i, i2);
            }
            return null;
        }

        @Override
        public boolean retainAll(Collection collection) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.retainAll(collection);
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection collection) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.removeAll(collection);
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection collection) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.containsAll(collection);
            }
            return false;
        }

        @Override
        public Object[] toArray(Object[] objects) {
            if (HazelcastDistributedListProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                return this.list.toArray(objects);
            }
            return null;
        }

        public String getListenerId() {
            return this.listenerId;
        }
    }
}

