/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.tenant.TenantMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageQueue;

class TenantEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(TenantEventMessageDelegator.class);
    private TenantEventMessageQueue messageQueue;
    private MessageProcessorChain processorChain;
    private boolean terminated;

    public TenantEventMessageDelegator(TenantEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new TenantMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.processorChain.removeEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Tenant event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Tenant event message received from queue: %s", type));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating tenant event message: %s", type));
                        }
                        this.processorChain.process(type, json, null);
                    }
                    catch (InterruptedException ignore) {
                        log.info((Object)"Shutting down tenant event message delegator...");
                        this.terminate();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve tenant event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Tenant event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

