/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.notifier;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.StratosEventReceiver;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InstanceNotifierEventReceiver
extends StratosEventReceiver {
    private static final Log log = LogFactory.getLog(InstanceNotifierEventReceiver.class);
    private final InstanceNotifierEventMessageDelegator messageDelegator;
    private EventSubscriber eventSubscriber;
    private InstanceNotifierEventMessageListener messageListener;
    private static volatile InstanceNotifierEventReceiver instance;

    private InstanceNotifierEventReceiver() {
        InstanceNotifierEventMessageQueue messageQueue = new InstanceNotifierEventMessageQueue();
        this.messageDelegator = new InstanceNotifierEventMessageDelegator(messageQueue);
        this.messageListener = new InstanceNotifierEventMessageListener(messageQueue);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstanceNotifierEventReceiver getInstance() {
        if (instance != null) return instance;
        Class<InstanceNotifierEventReceiver> clazz = InstanceNotifierEventReceiver.class;
        synchronized (InstanceNotifierEventReceiver.class) {
            if (instance != null) return instance;
            instance = new InstanceNotifierEventReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    private void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INSTANCE_NOTIFIER_TOPIC.getTopicName(), this.messageListener);
                this.executor.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instance Notifier event message receiver thread started");
                }
                this.executor.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instance Notifier  event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Instance Notifier receiver failed", (Throwable)e);
            }
        }
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }

    @Override
    public synchronized void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }
}

