/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application.signup;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.signup.ApplicationSignUp;
import org.apache.stratos.messaging.event.application.signup.CompleteApplicationSignUpsEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpManager;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class CompleteApplicationSignUpsMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(CompleteApplicationSignUpsMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (type.equals(CompleteApplicationSignUpsEvent.class.getName())) {
            CompleteApplicationSignUpsEvent event = (CompleteApplicationSignUpsEvent)MessagingUtil.jsonToObject(message, CompleteApplicationSignUpsEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to CompleteApplicationSignUpsEvent");
                return false;
            }
            if (!ApplicationSignUpManager.getInstance().isInitialized()) {
                try {
                    ApplicationSignUpManager.acquireWriteLock();
                    for (ApplicationSignUp applicationSignUp : event.getApplicationSignUps()) {
                        ApplicationSignUpManager.getInstance().addApplicationSignUp(applicationSignUp);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Application signup added: [application-id] %s [tenant-id] %s", applicationSignUp.getApplicationId(), applicationSignUp.getTenantId()));
                    }
                    ApplicationSignUpManager.getInstance().setInitialized(true);
                    log.info((Object)"Application signups initialized");
                }
                finally {
                    ApplicationSignUpManager.releaseWriteLock();
                }
            }
            if (!DomainMappingManager.getInstance().isInitialized()) {
                try {
                    DomainMappingManager.acquireWriteLock();
                    for (ApplicationSignUp applicationSignUp : event.getApplicationSignUps()) {
                        if (applicationSignUp.getDomainMappings() == null) continue;
                        DomainMappingManager.getInstance().addDomainMappings(Arrays.asList(applicationSignUp.getDomainMappings()));
                    }
                    DomainMappingManager.getInstance().setInitialized(true);
                    log.info((Object)"Domain mappings initialized");
                }
                finally {
                    DomainMappingManager.releaseWriteLock();
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

