/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence;

import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.persistence.ModulePersistenceManager;
import org.wso2.carbon.core.persistence.OperationPersistenceManager;
import org.wso2.carbon.core.persistence.ServiceGroupPersistenceManager;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;

public class PersistenceFactory {
    private static Log log = LogFactory.getLog(PersistenceFactory.class);
    private ServicePersistenceManager spm;
    private ServiceGroupPersistenceManager sgpm;
    private ModulePersistenceManager mpm;
    private OperationPersistenceManager opm;
    private ServiceGroupFilePersistenceManager sfpm;
    private ModuleFilePersistenceManager mfpm;
    private AxisConfiguration axisConfig;

    private PersistenceFactory(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public static PersistenceFactory getInstance(AxisConfiguration axisConfig) throws AxisFault {
        Object obj = axisConfig.getParameterValue("PersistenceFactory");
        PersistenceFactory pf = null;
        if (obj instanceof PersistenceFactory) {
            pf = (PersistenceFactory)obj;
        } else {
            pf = new PersistenceFactory(axisConfig);
            axisConfig.addParameter("PersistenceFactory", (Object)pf);
        }
        return pf;
    }

    public ServicePersistenceManager getServicePM() {
        if (this.spm == null) {
            try {
                this.spm = new ServicePersistenceManager(this.axisConfig, this);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while initializing the ServicePersistenceManager instance", (Throwable)axisFault);
            }
        }
        return this.spm;
    }

    public ServiceGroupPersistenceManager getServiceGroupPM() {
        if (this.sgpm == null) {
            try {
                this.sgpm = new ServiceGroupPersistenceManager(this.axisConfig, this);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while initializing the ServiceGroupPersistenceManager instance", (Throwable)axisFault);
            }
        }
        return this.sgpm;
    }

    public OperationPersistenceManager getOperationPM() {
        if (this.opm == null) {
            try {
                this.opm = new OperationPersistenceManager(this.axisConfig, this);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while initializing the OperationServicePersistenceManager instance", (Throwable)axisFault);
            }
        }
        return this.opm;
    }

    public ModulePersistenceManager getModulePM() {
        if (this.mpm == null) {
            try {
                this.mpm = new ModulePersistenceManager(this.axisConfig, this);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while initializing the ModulePersistenceManager instance", (Throwable)axisFault);
            }
        }
        return this.mpm;
    }

    public ServiceGroupFilePersistenceManager getServiceGroupFilePM() {
        if (this.sfpm == null) {
            try {
                this.sfpm = new ServiceGroupFilePersistenceManager(this.axisConfig);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while initializing the ServiceGroupFilePersistenceManager instance", (Throwable)axisFault);
                return null;
            }
        }
        this.sfpm.init();
        return this.sfpm;
    }

    public ModuleFilePersistenceManager getModuleFilePM() {
        if (this.mfpm == null) {
            try {
                this.mfpm = new ModuleFilePersistenceManager(this.axisConfig);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while initializing the ModuleFilePersistenceManager instance", (Throwable)axisFault);
                return null;
            }
        }
        this.mfpm.init();
        return this.mfpm;
    }
}

