/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.entry.Entry;

public class FileBucketEntry
implements Entry,
Externalizable {
    public String indexName;
    public String fileName;
    public Long bucketIndex;
    public byte[] data;

    public FileBucketEntry() {
    }

    public FileBucketEntry(String indexName, String fileName) {
        this.indexName = indexName;
        this.fileName = fileName;
    }

    public FileBucketEntry(String indexName, String fileName, long bucketIndex, byte[] data) {
        this.indexName = indexName;
        this.fileName = fileName;
        this.bucketIndex = bucketIndex;
        this.data = data;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.indexName);
        if (this.fileName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.fileName);
        }
        if (this.bucketIndex == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.bucketIndex);
        }
        if (this.data == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size;
        this.indexName = in.readUTF();
        if (in.readBoolean()) {
            this.fileName = in.readUTF();
        }
        if (in.readBoolean()) {
            this.bucketIndex = in.readLong();
        }
        if ((size = in.readInt()) > 0) {
            int bytesRead;
            this.data = new byte[size];
            int index = 0;
            while ((bytesRead = in.read(this.data, index, size)) != size) {
                index += bytesRead;
                size -= bytesRead;
            }
        }
    }

    public static String[] __getSpaceIndexedFields() {
        return new String[]{"bucketIndex", "fileName"};
    }
}

