/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.indexer;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;
import org.compass.core.CompassSession;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.embedded.openjpa.CompassProductDerivation;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;

public class OpenJPAJpaIndexEntitiesIndexer
implements JpaIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog(OpenJPAJpaIndexEntitiesIndexer.class);
    private JpaGpsDevice jpaGpsDevice;

    public void setJpaGpsDevice(JpaGpsDevice jpaGpsDevice) {
        this.jpaGpsDevice = jpaGpsDevice;
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        for (IndexEntity indexEntity : entities) {
            EntityInformation entityInformation = (EntityInformation)indexEntity;
            if (this.jpaGpsDevice.isFilteredForIndex(entityInformation.getName())) continue;
            int fetchCount = this.jpaGpsDevice.getFetchCount();
            if (!this.jpaGpsDevice.isRunning()) {
                return;
            }
            EntityManagerWrapper wrapper = this.jpaGpsDevice.getEntityManagerWrapper().newInstance();
            try {
                wrapper.open();
                OpenJPAEntityManager entityManager = OpenJPAPersistence.cast((EntityManager)wrapper.getEntityManager());
                entityManager.setPopulateStoreCache(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.jpaGpsDevice.buildMessage("Indexing entities [" + entityInformation.getName() + "] using query [" + entityInformation.getQueryProvider() + "]"));
                }
                Query query = entityInformation.getQueryProvider().createQuery((EntityManager)entityManager, entityInformation);
                OpenJPAQuery openJPAQuery = OpenJPAPersistence.cast((Query)query);
                JDBCFetchPlan fetch = (JDBCFetchPlan)openJPAQuery.getFetchPlan();
                if (CompassProductDerivation.isReleasedVersion()) {
                    this.doSetFetchPlan(fetchCount, fetch);
                }
                List results = openJPAQuery.getResultList();
                for (Object item : results) {
                    session.create(item);
                    entityManager.evict(item);
                    session.evictAll();
                }
                entityManager.clear();
                wrapper.close();
            }
            catch (Exception e) {
                log.error((Object)this.jpaGpsDevice.buildMessage("Failed to index the database"), (Throwable)e);
                wrapper.closeOnError();
                if (!(e instanceof JpaGpsDeviceException)) {
                    throw new JpaGpsDeviceException(this.jpaGpsDevice.buildMessage("Failed to index the database"), e);
                }
                throw (JpaGpsDeviceException)e;
            }
        }
    }

    private void doSetFetchPlan(int fetchCount, JDBCFetchPlan fetch) {
        fetch.setFetchBatchSize(fetchCount);
        fetch.setResultSetType(ResultSetType.SCROLL_INSENSITIVE);
        fetch.setFetchDirection(FetchDirection.FORWARD);
        fetch.setLRSSizeAlgorithm(LRSSizeAlgorithm.UNKNOWN);
    }
}

