/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.local.LocalResponder;
import org.apache.axis2.transport.local.LocalResponseTransportOutDescription;
import org.apache.axis2.transport.local.LocalTransportSender;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalTransportReceiver {
    protected static final Log log = LogFactory.getLog(LocalTransportReceiver.class);
    public static ConfigurationContext CONFIG_CONTEXT;
    private ConfigurationContext confContext;
    private MessageContext inMessageContext;
    private boolean nonBlocking = false;
    public static final String IN_MESSAGE_CONTEXT = "IN_MESSAGE_CONTEXT";

    public LocalTransportReceiver(ConfigurationContext configContext) {
        this.confContext = configContext;
    }

    public LocalTransportReceiver(boolean nonBlocking, ConfigurationContext configContext) {
        this.confContext = configContext;
        this.nonBlocking = nonBlocking;
    }

    public LocalTransportReceiver(LocalTransportSender sender) {
        this(CONFIG_CONTEXT);
    }

    public LocalTransportReceiver(LocalTransportSender sender, boolean nonBlocking) {
        this(CONFIG_CONTEXT);
        this.nonBlocking = nonBlocking;
    }

    public void processMessage(MessageContext inMessageContext, InputStream in, OutputStream response) throws AxisFault {
        if (this.confContext == null) {
            this.confContext = inMessageContext.getConfigurationContext();
        }
        this.inMessageContext = inMessageContext;
        EndpointReference to = inMessageContext.getTo();
        String action = inMessageContext.getOptions().getAction();
        this.processMessage(in, to, action, response);
    }

    public void processMessage(ConfigurationContext configurationContext, InputStream in, EndpointReference to, String action, OutputStream response) throws AxisFault {
        if (this.confContext == null) {
            this.confContext = configurationContext;
        }
        this.processMessage(in, to, action, response);
    }

    public void processMessage(InputStream in, EndpointReference to, String action, OutputStream response) throws AxisFault {
        MessageContext msgCtx = this.confContext.createMessageContext();
        if (this.nonBlocking) {
            if (log.isDebugEnabled()) {
                log.debug("Setting the in-message context as a property(IN_MESSAGE_CONTEXT) to the current message context");
            }
            msgCtx.setProperty(IN_MESSAGE_CONTEXT, this.inMessageContext);
        }
        if (this.inMessageContext != null) {
            if (log.isDebugEnabled()) {
                log.debug("Setting the property " + HTTPConstants.MC_HTTP_SERVLETREQUEST + " to " + this.inMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST));
                log.debug("Setting the property REMOTE_ADDR to " + this.inMessageContext.getProperty("REMOTE_ADDR"));
            }
            msgCtx.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, this.inMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST));
            msgCtx.setProperty("REMOTE_ADDR", this.inMessageContext.getProperty("REMOTE_ADDR"));
        }
        TransportInDescription tIn = this.confContext.getAxisConfiguration().getTransportIn("local");
        TransportOutDescription tOut = this.confContext.getAxisConfiguration().getTransportOut("local");
        LocalResponseTransportOutDescription localTransportResOut = new LocalResponseTransportOutDescription(tOut);
        localTransportResOut.setSender(new LocalResponder(response));
        try {
            StAXBuilder builder;
            msgCtx.setIncomingTransportName("local");
            msgCtx.setTransportIn(tIn);
            msgCtx.setTransportOut(localTransportResOut);
            msgCtx.setProperty("TRANSPORT_OUT", response);
            Object headers = this.inMessageContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null) {
                msgCtx.setProperty("TRANSPORT_HEADERS", headers);
            }
            msgCtx.setTo(to);
            msgCtx.setWSAAction(action);
            msgCtx.setServerSide(true);
            InputStreamReader streamReader = new InputStreamReader(in);
            try {
                builder = BuilderUtil.getBuilder(streamReader);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            msgCtx.setEnvelope(envelope);
            if (log.isDebugEnabled()) {
                log.debug("Setting incoming Transport name - local");
                log.debug("Setting TransportIn - " + tIn);
                log.debug("Setting TransportOut - " + localTransportResOut);
                log.debug("Setting To address - " + to);
                log.debug("Setting WSAction - " + action);
                log.debug("Setting Envelope - " + envelope.toString());
            }
            AxisEngine.receive(msgCtx);
        }
        catch (AxisFault e) {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgCtx, e);
            faultContext.setTransportOut(localTransportResOut);
            faultContext.setProperty("TRANSPORT_OUT", response);
            if (log.isDebugEnabled()) {
                log.debug("Setting FaultContext's TransportOut - " + localTransportResOut);
            }
            AxisEngine.sendFault(faultContext);
        }
    }
}

