/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPProxyConfigurationUtil {
    private static Log log = LogFactory.getLog(HTTPProxyConfigurationUtil.class);
    protected static final String HTTP_PROXY_HOST = "http.proxyHost";
    protected static final String HTTP_PROXY_PORT = "http.proxyPort";
    protected static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    protected static final String ATTR_PROXY = "Proxy";
    protected static final String PROXY_HOST_ELEMENT = "ProxyHost";
    protected static final String PROXY_PORT_ELEMENT = "ProxyPort";
    protected static final String PROXY_USER_ELEMENT = "ProxyUser";
    protected static final String PROXY_PASSWORD_ELEMENT = "ProxyPassword";
    protected static final String PROXY_CONFIGURATION_NOT_FOUND = "HTTP Proxy is enabled, but proxy configuration element is missing in axis2.xml";
    protected static final String PROXY_HOST_ELEMENT_NOT_FOUND = "HTTP Proxy is enabled, but proxy host element is missing in axis2.xml";
    protected static final String PROXY_PORT_ELEMENT_NOT_FOUND = "HTTP Proxy is enabled, but proxy port element is missing in axis2.xml";
    protected static final String PROXY_HOST_ELEMENT_WITH_EMPTY_VALUE = "HTTP Proxy is enabled, but proxy host value is empty.";
    protected static final String PROXY_PORT_ELEMENT_WITH_EMPTY_VALUE = "HTTP Proxy is enabled, but proxy port value is empty.";

    public static void configure(MessageContext messageContext, HttpClient httpClient, HostConfiguration config) throws AxisFault {
        String port;
        String host;
        HttpTransportProperties.ProxyProperties proxyProperties;
        UsernamePasswordCredentials proxyCredentials = null;
        String proxyHost = null;
        Object nonProxyHosts = null;
        Integer proxyPort = -1;
        String proxyUser = null;
        String proxyPassword = null;
        Parameter proxySettingsFromAxisConfig = messageContext.getConfigurationContext().getAxisConfiguration().getParameter(ATTR_PROXY);
        if (proxySettingsFromAxisConfig != null) {
            OMElement proxyConfiguration = HTTPProxyConfigurationUtil.getProxyConfigurationElement(proxySettingsFromAxisConfig);
            proxyHost = HTTPProxyConfigurationUtil.getProxyHost(proxyConfiguration);
            proxyPort = HTTPProxyConfigurationUtil.getProxyPort(proxyConfiguration);
            proxyUser = HTTPProxyConfigurationUtil.getProxyUser(proxyConfiguration);
            proxyPassword = HTTPProxyConfigurationUtil.getProxyPassword(proxyConfiguration);
            if (proxyUser != null) {
                int proxyUserDomainIndex;
                if (proxyPassword == null) {
                    proxyPassword = "";
                }
                if ((proxyUserDomainIndex = proxyUser.indexOf("\\")) > 0) {
                    String domain = proxyUser.substring(0, proxyUserDomainIndex);
                    if (proxyUser.length() > proxyUserDomainIndex + 1) {
                        String user = proxyUser.substring(proxyUserDomainIndex + 1);
                        proxyCredentials = new NTCredentials(user, proxyPassword, proxyHost, domain);
                    }
                }
                proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            }
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)messageContext.getProperty("PROXY")) != null) {
            String proxyHostProp = proxyProperties.getProxyHostName();
            if (proxyHostProp == null || proxyHostProp.length() <= 0) {
                throw new AxisFault("HTTP Proxy host is not available. Host is a MUST parameter");
            }
            proxyHost = proxyHostProp;
            proxyPort = proxyProperties.getProxyPort();
            String userName = proxyProperties.getUserName();
            String password = proxyProperties.getPassWord();
            String domain = proxyProperties.getDomain();
            if (userName != null && password != null && domain != null) {
                proxyCredentials = new NTCredentials(userName, password, proxyHost, domain);
            } else if (userName != null && domain == null) {
                proxyCredentials = new UsernamePasswordCredentials(userName, password);
            }
        }
        if ((host = System.getProperty(HTTP_PROXY_HOST)) != null) {
            proxyHost = host;
        }
        if ((port = System.getProperty(HTTP_PROXY_PORT)) != null) {
            proxyPort = Integer.parseInt(port);
        }
        if (proxyCredentials != null) {
            httpClient.getParams().setAuthenticationPreemptive(true);
            HttpState cachedHttpState = (HttpState)messageContext.getProperty("CACHED_HTTP_STATE");
            if (cachedHttpState != null) {
                httpClient.setState(cachedHttpState);
            }
            httpClient.getState().setProxyCredentials(AuthScope.ANY, proxyCredentials);
        }
        config.setProxy(proxyHost, proxyPort);
    }

    private static OMElement getProxyConfigurationElement(Parameter proxySettingsFromAxisConfig) throws AxisFault {
        OMElement proxyConfigurationElement = proxySettingsFromAxisConfig.getParameterElement().getFirstElement();
        if (proxyConfigurationElement == null) {
            log.error(PROXY_CONFIGURATION_NOT_FOUND);
            throw new AxisFault(PROXY_CONFIGURATION_NOT_FOUND);
        }
        return proxyConfigurationElement;
    }

    private static String getProxyHost(OMElement proxyConfiguration) throws AxisFault {
        OMElement proxyHostElement = proxyConfiguration.getFirstChildWithName(new QName(PROXY_HOST_ELEMENT));
        if (proxyHostElement == null) {
            log.error(PROXY_HOST_ELEMENT_NOT_FOUND);
            throw new AxisFault(PROXY_HOST_ELEMENT_NOT_FOUND);
        }
        String proxyHost = proxyHostElement.getText();
        if (proxyHost == null) {
            log.error(PROXY_HOST_ELEMENT_WITH_EMPTY_VALUE);
            throw new AxisFault(PROXY_HOST_ELEMENT_WITH_EMPTY_VALUE);
        }
        return proxyHost;
    }

    private static Integer getProxyPort(OMElement proxyConfiguration) throws AxisFault {
        OMElement proxyPortElement = proxyConfiguration.getFirstChildWithName(new QName(PROXY_PORT_ELEMENT));
        if (proxyPortElement == null) {
            log.error(PROXY_PORT_ELEMENT_NOT_FOUND);
            throw new AxisFault(PROXY_PORT_ELEMENT_NOT_FOUND);
        }
        String proxyPort = proxyPortElement.getText();
        if (proxyPort == null) {
            log.error(PROXY_PORT_ELEMENT_WITH_EMPTY_VALUE);
            throw new AxisFault(PROXY_PORT_ELEMENT_WITH_EMPTY_VALUE);
        }
        return Integer.parseInt(proxyPort);
    }

    private static String getProxyUser(OMElement proxyConfiguration) {
        OMElement proxyUserElement = proxyConfiguration.getFirstChildWithName(new QName(PROXY_USER_ELEMENT));
        if (proxyUserElement == null) {
            return null;
        }
        String proxyUser = proxyUserElement.getText();
        if (proxyUser == null) {
            log.warn("Empty user name element in HTTP Proxy settings.");
            return null;
        }
        return proxyUser;
    }

    private static String getProxyPassword(OMElement proxyConfiguration) {
        OMElement proxyPasswordElement = proxyConfiguration.getFirstChildWithName(new QName(PROXY_PASSWORD_ELEMENT));
        if (proxyPasswordElement == null) {
            return null;
        }
        String proxyUser = proxyPasswordElement.getText();
        if (proxyUser == null) {
            log.warn("Empty user name element in HTTP Proxy settings.");
            return null;
        }
        return proxyUser;
    }

    public static boolean isProxyEnabled(MessageContext messageContext, URL targetURL) {
        boolean proxyEnabled = false;
        Parameter param = messageContext.getConfigurationContext().getAxisConfiguration().getParameter(ATTR_PROXY);
        Object obj = messageContext.getProperty("PROXY");
        String sp = System.getProperty(HTTP_PROXY_HOST);
        if (param != null || obj != null || sp != null) {
            proxyEnabled = true;
        }
        boolean isNonProxyHost = HTTPProxyConfigurationUtil.validateNonProxyHosts(targetURL.getHost());
        return proxyEnabled && !isNonProxyHost;
    }

    private static boolean validateNonProxyHosts(String host) {
        String nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        return HTTPProxyConfigurationUtil.isHostInNonProxyList(host, nonProxyHosts);
    }

    public static boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!HTTPProxyConfigurationUtil.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }
}

