/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.JavaUtils;

public class DispatchPhase
extends Phase {
    private static final QName SERVICE_GROUP_QNAME = new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2");

    public DispatchPhase() {
    }

    public DispatchPhase(String phaseName) {
        super(phaseName);
    }

    private Boolean getDisableAck(MessageContext msgContext) throws AxisFault {
        Boolean disableAck = (Boolean)msgContext.getProperty("DisableResponseAck");
        if (disableAck == null) {
            disableAck = (Boolean)(msgContext.getAxisService() != null ? msgContext.getAxisService().getParameterValue("DisableResponseAck") : null);
        }
        return disableAck;
    }

    @Override
    public void checkPostConditions(MessageContext msgContext) throws AxisFault {
        Boolean disableAck;
        Object requestResponseTransport;
        String mepString;
        EndpointReference toEPR = msgContext.getTo();
        if (msgContext.getAxisService() == null) {
            AxisFault fault = new AxisFault(Messages.getMessage("servicenotfoundforepr", toEPR != null ? toEPR.getAddress() : ""));
            fault.setFaultCode("Client");
            throw fault;
        }
        AxisService service = msgContext.getAxisService();
        AxisOperation operation = msgContext.getAxisOperation();
        if (operation == null && JavaUtils.isTrue(service.getParameterValue("supportSingleOperation"))) {
            Iterator<AxisOperation> ops = service.getOperations();
            if (ops.hasNext()) {
                operation = ops.next();
                if (ops.hasNext()) {
                    operation = null;
                }
            }
            msgContext.setAxisOperation(operation);
        }
        if (operation == null) {
            AxisFault fault = new AxisFault(Messages.getMessage("operationnotfoundforepr2", toEPR != null ? toEPR.getAddress() : "", msgContext.getWSAAction()));
            fault.setFaultCode("Client");
            throw fault;
        }
        this.validateTransport(msgContext);
        this.validateBindings(msgContext);
        this.loadContexts(service, msgContext);
        if (msgContext.getOperationContext() == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullOperationContext"));
        }
        if (msgContext.getServiceContext() == null) {
            throw new AxisFault(Messages.getMessage("cannotBeNullServiceContext"));
        }
        if (msgContext.getAxisOperation() == null && msgContext.getOperationContext() != null) {
            msgContext.setAxisOperation(msgContext.getOperationContext().getAxisOperation());
        }
        if (msgContext.getAxisService() == null && msgContext.getServiceContext() != null) {
            msgContext.setAxisService(msgContext.getServiceContext().getAxisService());
        }
        if (this.isOneway(mepString = msgContext.getAxisOperation().getMessageExchangePattern())) {
            Boolean disableAck2;
            requestResponseTransport = msgContext.getProperty("RequestResponseTransportControl");
            if (!(requestResponseTransport == null || (disableAck2 = this.getDisableAck(msgContext)) != null && disableAck2.booleanValue())) {
                ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(msgContext);
            }
        } else if (AddressingHelper.isReplyRedirected(msgContext) && AddressingHelper.isFaultRedirected(msgContext) && (mepString.equals("http://www.w3.org/2006/01/wsdl/in-out") || mepString.equals("http://www.w3.org/2004/08/wsdl/in-out") || mepString.equals("http://www.w3.org/ns/wsdl/in-out")) && (requestResponseTransport = msgContext.getProperty("RequestResponseTransportControl")) != null && ((disableAck = this.getDisableAck(msgContext)) == null || !disableAck.booleanValue())) {
            ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(msgContext);
        }
        ArrayList operationChain = msgContext.getAxisOperation().getRemainingPhasesInFlow();
        msgContext.setExecutionChain((ArrayList)operationChain.clone());
    }

    private void loadContexts(AxisService service, MessageContext msgContext) throws AxisFault {
        String scope = service == null ? null : service.getScope();
        ServiceContext serviceContext = msgContext.getServiceContext();
        if (msgContext.getOperationContext() != null && serviceContext != null) {
            msgContext.setServiceGroupContextId(((ServiceGroupContext)serviceContext.getParent()).getId());
            return;
        }
        if ("transportsession".equals(scope)) {
            this.fillContextsFromSessionContext(msgContext);
        } else if ("soapsession".equals(scope)) {
            this.extractServiceGroupContextId(msgContext);
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        OperationContext operationContext = axisOperation.findForExistingOperationContext(msgContext);
        if (operationContext != null) {
            axisOperation.registerMessageContext(msgContext, operationContext);
            serviceContext = (ServiceContext)operationContext.getParent();
            ServiceGroupContext serviceGroupContext = (ServiceGroupContext)serviceContext.getParent();
            msgContext.setServiceContext(serviceContext);
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceGroupContextId(serviceGroupContext.getId());
        } else {
            if (serviceContext == null) {
                msgContext.getConfigurationContext().fillServiceContextAndServiceGroupContext(msgContext);
                serviceContext = msgContext.getServiceContext();
            }
            operationContext = serviceContext.createOperationContext(axisOperation);
            axisOperation.registerMessageContext(msgContext, operationContext);
        }
        serviceContext.setMyEPR(msgContext.getTo());
    }

    private void validateTransport(MessageContext msgctx) throws AxisFault {
        AxisService service = msgctx.getAxisService();
        if (service.isEnableAllTransports()) {
            return;
        }
        List<String> trs = service.getExposedTransports();
        String incomingTrs = msgctx.getIncomingTransportName();
        if ("local".equals(incomingTrs)) {
            return;
        }
        for (int i = 0; i < trs.size(); ++i) {
            String tr = trs.get(i);
            if (incomingTrs == null || !incomingTrs.equals(tr)) continue;
            return;
        }
        EndpointReference toEPR = msgctx.getTo();
        throw new AxisFault(Messages.getMessage("servicenotfoundforepr", toEPR != null ? toEPR.getAddress() : ""));
    }

    private void validateBindings(MessageContext msgctx) throws AxisFault {
        AxisService service = msgctx.getAxisService();
        if (msgctx.isDoingREST()) {
            boolean disableREST = false;
            Parameter disableRESTParameter = service.getParameter("disableREST");
            if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
                disableREST = true;
            }
            if (disableREST) {
                throw new AxisFault(Messages.getMessage("bindingDisabled", "Http"));
            }
        } else if (msgctx.isSOAP11()) {
            boolean disableSOAP11 = false;
            Parameter disableSOAP11Parameter = service.getParameter("disableSOAP11");
            if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP11Parameter.getValue())) {
                disableSOAP11 = true;
            }
            if (disableSOAP11) {
                throw new AxisFault(Messages.getMessage("bindingDisabled", "SOAP11"));
            }
        } else {
            boolean disableSOAP12 = false;
            Parameter disableSOAP12Parameter = service.getParameter("disableSOAP12");
            if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP12Parameter.getValue())) {
                disableSOAP12 = true;
            }
            if (disableSOAP12) {
                throw new AxisFault(Messages.getMessage("bindingDisabled", "SOAP12"));
            }
        }
    }

    private void fillContextsFromSessionContext(MessageContext msgContext) throws AxisFault {
        TransportListener listener;
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            throw new AxisFault(Messages.getMessage("unabletofindservice"));
        }
        SessionContext sessionContext = msgContext.getSessionContext();
        if (sessionContext == null && (sessionContext = (listener = msgContext.getTransportIn().getReceiver()).getSessionContext(msgContext)) == null) {
            this.createAndFillContexts(service, msgContext, sessionContext);
            return;
        }
        String serviceGroupName = msgContext.getAxisServiceGroup().getServiceGroupName();
        ServiceGroupContext serviceGroupContext = sessionContext.getServiceGroupContext(serviceGroupName);
        if (serviceGroupContext != null) {
            msgContext.setServiceGroupContext(serviceGroupContext);
            msgContext.setServiceContext(serviceGroupContext.getServiceContext(service));
        } else {
            this.createAndFillContexts(service, msgContext, sessionContext);
        }
        ServiceContext serviceContext = sessionContext.getServiceContext(service);
        if (serviceContext != null) {
            msgContext.setServiceContext(serviceContext);
            serviceContext.setProperty("Cookie", sessionContext.getCookieID());
        }
    }

    private void createAndFillContexts(AxisService service, MessageContext msgContext, SessionContext sessionContext) throws AxisFault {
        AxisServiceGroup axisServiceGroup = service.getAxisServiceGroup();
        ConfigurationContext configCtx = msgContext.getConfigurationContext();
        ServiceGroupContext serviceGroupContext = configCtx.createServiceGroupContext(axisServiceGroup);
        msgContext.setServiceGroupContext(serviceGroupContext);
        ServiceContext serviceContext = serviceGroupContext.getServiceContext(service);
        msgContext.setServiceContext(serviceContext);
        if (sessionContext != null) {
            sessionContext.addServiceContext(serviceContext);
            sessionContext.addServiceGroupContext(serviceGroupContext);
        }
    }

    private void extractServiceGroupContextId(MessageContext msgContext) throws AxisFault {
        OMElement serviceGroupId;
        SOAPHeader soapHeader = msgContext.getEnvelope().getHeader();
        if (soapHeader != null && (serviceGroupId = soapHeader.getFirstChildWithName(SERVICE_GROUP_QNAME)) != null) {
            msgContext.setServiceGroupContextId(serviceGroupId.getText());
        }
    }

    boolean isOneway(String mepString) {
        return mepString.equals("http://www.w3.org/2006/01/wsdl/in-only") || mepString.equals("http://www.w3.org/2004/08/wsdl/in-only") || mepString.equals("http://www.w3.org/ns/wsdl/in-only");
    }
}

