/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dataretrieval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataLocatorFactory;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.DataRetrievalUtil;
import org.apache.axis2.dataretrieval.ServiceData;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisDataLocatorImpl
implements AxisDataLocator {
    private static final Log log = LogFactory.getLog(AxisDataLocatorImpl.class);
    private HashMap dataMap = new HashMap();
    private AxisService axisService;

    public AxisDataLocatorImpl(AxisService in_axisService) throws DataRetrievalException {
        this.axisService = in_axisService;
    }

    @Override
    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws DataRetrievalException {
        AxisDataLocator dataLocator;
        Data[] data = null;
        String dialect = request.getDialect();
        String identifier = request.getIdentifier();
        String key = dialect;
        ArrayList dataList = new ArrayList();
        if (identifier != null) {
            if (this.dataMap.get(key = key + identifier) != null) {
                dataList.add(this.dataMap.get(key));
            }
        } else {
            dataList = this.getDataList(dialect);
        }
        if ((dataLocator = DataLocatorFactory.createDataLocator(dialect, dataList.toArray(new ServiceData[0]))) != null) {
            try {
                data = dataLocator.getData(request, msgContext);
            }
            catch (Throwable e) {
                log.info("getData request failed for dialect, " + dialect, e);
                throw new DataRetrievalException(e);
            }
        } else {
            String message = "Failed to instantiate Data Locator for dialect, " + dialect;
            log.info(message);
            throw new DataRetrievalException(message);
        }
        return data;
    }

    public void loadServiceData() {
        DataRetrievalUtil util = DataRetrievalUtil.getInstance();
        OMElement serviceData = null;
        String file = "META-INF/ServiceData.xml";
        try {
            serviceData = util.buildOM(this.axisService.getClassLoader(), "META-INF/ServiceData.xml");
        }
        catch (DataRetrievalException e) {
            String message = "Check loading failure for file, " + file;
            log.debug(message + ".Message = " + e.getMessage());
            log.debug(message, e);
        }
        if (serviceData != null) {
            this.cachingServiceData(serviceData);
        }
    }

    private void cachingServiceData(OMElement e) {
        Iterator i = e.getChildrenWithName(new QName("Data"));
        String saveKey = "";
        while (i.hasNext()) {
            ServiceData data = new ServiceData((OMElement)i.next());
            saveKey = data.getDialect();
            String identifier = data.getIdentifier();
            if (identifier != null) {
                saveKey = saveKey + identifier;
            }
            this.dataMap.put(saveKey, data);
        }
    }

    private ArrayList getDataList(String dialect) {
        ArrayList dataList = new ArrayList();
        for (String keyStr : this.dataMap.keySet()) {
            if (keyStr.indexOf(dialect) != 0) continue;
            dataList.add(this.dataMap.get(keyStr));
        }
        return dataList;
    }
}

