/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;

public class UserMgtInitializer {
    private static Log log = LogFactory.getLog(UserMgtInitializer.class);

    public void start(BundleContext bc, RegistryService registryService) throws Exception {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain("carbon.super");
        carbonContext.setTenantId(-1234);
        this.addPermissions(registryService);
    }

    private void addPermissions(RegistryService registryService) throws Exception {
        try {
            UserRegistry registry = registryService.getGovernanceSystemRegistry();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("/permission", "All Permissions");
            map.put("/permission/admin", "Admin Permissions");
            map.put("/permission/protected/", "Super Admin Permissions");
            map.put("/permission/admin/manage", "Manage");
            map.put("/permission/admin/monitor", "Monitor");
            map.put("/permission/admin/manage/modify", "Configure");
            map.put("/permission/admin/manage/add", "Add");
            map.put("/permission/admin/configure", "Configure");
            map.put("/permission/admin/configure/security", "Security");
            map.put("/permission/admin/configure/security/usermgt", "Identity Management");
            map.put("/permission/admin/configure/security/usermgt/users", "User Management");
            map.put("/permission/admin/configure/security/usermgt/passwords", "Password Management");
            map.put("/permission/admin/configure/security/usermgt/profiles", "Profile Management");
            map.put("/permission/admin/login", "Login");
            for (Map.Entry entry : map.entrySet()) {
                Collection resource;
                String resourcePath = (String)entry.getKey();
                String displayName = (String)entry.getValue();
                if (registry.resourceExists(resourcePath)) {
                    resource = registry.get(resourcePath);
                    if (resource.getProperty("name") != null) continue;
                    resource.setProperty("name", displayName);
                    registry.put(resourcePath, (Resource)resource);
                    continue;
                }
                resource = registry.newCollection();
                resource.setProperty("name", displayName);
                registry.put(resourcePath, (Resource)resource);
            }
            UserRealm realm = registry.getUserRealm();
            String adminRole = realm.getRealmConfiguration().getAdminRoleName();
            AuthorizationManager authMan = realm.getAuthorizationManager();
            if (!authMan.isRoleAuthorized(adminRole, "/permission", "ui.execute")) {
                authMan.authorizeRole(adminRole, "/permission", "ui.execute");
            }
        }
        catch (Exception e) {
            log.error((Object)("While adding management permission :: " + e.getMessage()), (Throwable)e);
            throw new Exception("While adding management permission :: " + e.getMessage(), e);
        }
    }
}

