/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.util;

import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MemberUtils {
    private static final Log log = LogFactory.getLog(MemberUtils.class);
    private static Map<String, Parameter> parameters;
    private static ConfigurationContext configurationContext;
    private static boolean isInitialized;

    public static void init(Map<String, Parameter> parameters, ConfigurationContext configurationContext) {
        MemberUtils.parameters = parameters;
        MemberUtils.configurationContext = configurationContext;
        isInitialized = true;
    }

    public static boolean canConnect(Member wkaMember) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to connect to WKA member " + wkaMember + "..."));
        }
        try {
            InetAddress addr = InetAddress.getByName(wkaMember.getHostName());
            InetSocketAddress sockAddr = new InetSocketAddress(addr, wkaMember.getPort());
            new Socket().connect(sockAddr, 10000);
            return true;
        }
        catch (IOException e) {
            String msg;
            if (log.isDebugEnabled()) {
                log.debug((Object)"", (Throwable)e);
            }
            if (!(msg = e.getMessage()).contains("Connection refused") && !msg.contains("connect timed out")) {
                log.error((Object)("Cannot connect to WKA member " + wkaMember), (Throwable)e);
            }
            return false;
        }
    }

    public static void addMember(Member member, TcpIpConfig config) {
        String memberStr = member.getHostName() + ":" + member.getPort();
        if (!config.getMembers().contains(memberStr)) {
            config.addMember(memberStr);
            log.info((Object)("Added member: " + member));
        }
    }

    public static Member getLocalMember(String domain, String localMemberHost, int localMemberPort) {
        Parameter propsParam;
        Parameter isActiveParam;
        Parameter port;
        TransportInDescription httpsTransport;
        Parameter port2;
        if (!isInitialized) {
            throw new IllegalStateException("MemberUtils not initialized. Call MemberUtils.init() first");
        }
        Member member = new Member(localMemberHost, localMemberPort);
        Properties memberInfo = new Properties();
        AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
        TransportInDescription httpTransport = axisConfig.getTransportIn("http");
        int portOffset = 0;
        Parameter param = MemberUtils.getParameter("AvoidInitiation");
        if (param != null && !JavaUtils.isTrueExplicitly((Object)param.getValue()) && System.getProperty("portOffset") != null) {
            portOffset = Integer.parseInt(System.getProperty("portOffset"));
        }
        if (httpTransport != null && (port2 = httpTransport.getParameter("port")) != null) {
            int httpPort = Integer.valueOf((String)port2.getValue()) + portOffset;
            member.setHttpPort(httpPort);
        }
        if ((httpsTransport = axisConfig.getTransportIn("https")) != null && (port = httpsTransport.getParameter("port")) != null) {
            int httpsPort = Integer.valueOf((String)port.getValue()) + portOffset;
            member.setHttpsPort(httpsPort);
        }
        if ((isActiveParam = MemberUtils.getParameter("isActive")) != null) {
            memberInfo.setProperty("isActive", (String)isActiveParam.getValue());
        }
        if (localMemberHost != null) {
            memberInfo.setProperty("hostName", localMemberHost);
        }
        if ((propsParam = MemberUtils.getParameter("properties")) != null) {
            OMElement paramEle = propsParam.getParameterElement();
            Iterator iter = paramEle.getChildrenWithLocalName("property");
            while (iter.hasNext()) {
                OMElement propEle = (OMElement)iter.next();
                OMAttribute nameAttrib = propEle.getAttribute(new QName("name"));
                if (nameAttrib == null) continue;
                String attribName = nameAttrib.getAttributeValue();
                attribName = MemberUtils.replaceProperty(attribName, memberInfo);
                OMAttribute valueAttrib = propEle.getAttribute(new QName("value"));
                if (valueAttrib == null) continue;
                String attribVal = valueAttrib.getAttributeValue();
                attribVal = MemberUtils.replaceProperty(attribVal, memberInfo);
                memberInfo.setProperty(attribName, attribVal);
            }
        }
        memberInfo.remove("hostName");
        member.setProperties(memberInfo);
        member.setDomain(domain);
        return member;
    }

    private static Parameter getParameter(String name) {
        return parameters.get(name);
    }

    private static String replaceProperty(String text, Properties props) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = props.getProperty(sysProp);
            if (propValue == null) {
                propValue = System.getProperty(sysProp);
            }
            if (propValue == null) continue;
            text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
        }
        return text;
    }

    public static IMap<String, Member> getMembersMap(HazelcastInstance hazelcastInstance, String domain) {
        return hazelcastInstance.getMap("$" + domain + ".members");
    }

    private MemberUtils() {
    }
}

