/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.event.initializer.CompleteTopologyRequestEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class TopologyEventReceiver {
    private static final Log log = LogFactory.getLog(TopologyEventReceiver.class);
    private TopologyEventMessageDelegator messageDelegator;
    private TopologyEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private ExecutorService executorService;

    public TopologyEventReceiver() {
        TopologyEventMessageQueue messageQueue = new TopologyEventMessageQueue();
        this.messageDelegator = new TopologyEventMessageDelegator(messageQueue);
        this.messageListener = new TopologyEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.TOPOLOGY_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Topology event message receiver thread started");
                }
                this.executorService.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Topology event message delegator thread started");
                }
                this.initializeCompleteTopology();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Topology receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public void initializeCompleteTopology() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (!TopologyEventReceiver.this.eventSubscriber.isSubscribed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                CompleteTopologyRequestEvent completeTopologyRequestEvent = new CompleteTopologyRequestEvent();
                String topic = MessagingUtil.getMessageTopicName(completeTopologyRequestEvent);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher(topic);
                eventPublisher.publish(completeTopologyRequestEvent);
            }
        });
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

