/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.notifier;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InstanceNotifierEventReceiver {
    private static final Log log = LogFactory.getLog(InstanceNotifierEventReceiver.class);
    private final InstanceNotifierEventMessageDelegator messageDelegator;
    private EventSubscriber eventSubscriber;
    private boolean terminated;

    public InstanceNotifierEventReceiver() {
        InstanceNotifierEventMessageQueue messageQueue = new InstanceNotifierEventMessageQueue();
        this.messageDelegator = new InstanceNotifierEventMessageDelegator(messageQueue);
        InstanceNotifierEventMessageListener messageListener = new InstanceNotifierEventMessageListener(messageQueue);
        this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INSTANCE_NOTIFIER_TOPIC.getTopicName(), messageListener);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        InstanceNotifierEventReceiver instanceNotifierEventReceiver = this;
        synchronized (instanceNotifierEventReceiver) {
            block11: {
                if (this.terminated) {
                    log.info((Object)"InstanceNotifierEventReceiver has been terminated. Event subscriber will not be created.");
                    return;
                }
                try {
                    Thread subscriberThread = new Thread(this.eventSubscriber);
                    subscriberThread.start();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"InstanceNotifier event message receiver thread started");
                    }
                    Thread receiverThread = new Thread(this.messageDelegator);
                    receiverThread.start();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"InstanceNotifier event message delegator thread started");
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block11;
                    log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
                }
            }
        }
        log.info((Object)"InstanceNotifierEventReceiver started");
        while (!this.terminated) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }

    public synchronized void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
        log.info((Object)"InstanceNotifierEventReceiver terminated");
    }
}

