/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.initializer;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageListener;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InitializerEventReceiver {
    private static final Log log = LogFactory.getLog(InitializerEventReceiver.class);
    private InitializerEventMessageDelegator messageDelegator;
    private InitializerEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private ExecutorService executorService;

    public InitializerEventReceiver() {
        InitializerEventMessageQueue initializerEventMessageQueue = new InitializerEventMessageQueue();
        this.messageDelegator = new InitializerEventMessageDelegator(initializerEventMessageQueue);
        this.messageListener = new InitializerEventMessageListener(initializerEventMessageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block3: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INITIALIZER_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initializer event message delegator thread started");
                }
                this.executorService.execute(this.messageDelegator);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Initializer receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

