/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.initializer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.message.receiver.initializer.InitializerEventMessageQueue;

public class InitializerEventMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(InitializerEventMessageListener.class);
    private final InitializerEventMessageQueue messageQueue;

    public InitializerEventMessageListener(InitializerEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public void messageReceived(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Initializer event message received: %s", message.getText()));
            }
            this.messageQueue.add(message);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

