/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.cluster.status;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.cluster.status.ClusterStatusMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageQueue;

class ClusterStatusEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(ClusterStatusEventMessageDelegator.class);
    private ClusterStatusEventMessageQueue messageQueue;
    private MessageProcessorChain processorChain;
    private boolean terminated;

    public ClusterStatusEventMessageDelegator(ClusterStatusEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new ClusterStatusMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Cluster Status event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Cluster status event message received from queue: %s", type));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating cluster status event message: %s", type));
                        }
                        this.processorChain.process(type, json, null);
                    }
                    catch (InterruptedException ignore) {
                        log.info((Object)"Shutting down cluster status event message delegator...");
                        this.terminate();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve cluster status event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Instance notifier event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

