/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.event.initializer.CompleteApplicationsRequestEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageListener;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationsEventReceiver {
    private static final Log log = LogFactory.getLog(ApplicationsEventReceiver.class);
    private ApplicationsEventMessageDelegator messageDelegator;
    private ApplicationsEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private ExecutorService executorService;

    public ApplicationsEventReceiver() {
        ApplicationsEventMessageQueue messageQueue = new ApplicationsEventMessageQueue();
        this.messageDelegator = new ApplicationsEventMessageDelegator(messageQueue);
        this.messageListener = new ApplicationsEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.messageDelegator.removeEventListener(eventListener);
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.APPLICATION_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application status event message receiver thread started");
                }
                this.executorService.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application status event message delegator thread started");
                }
                this.initializeCompleteApplicationsModel();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Application status failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public void initializeCompleteApplicationsModel() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (!ApplicationsEventReceiver.this.eventSubscriber.isSubscribed()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                CompleteApplicationsRequestEvent completeApplicationsRequestEvent = new CompleteApplicationsRequestEvent();
                String topic = MessagingUtil.getMessageTopicName(completeApplicationsRequestEvent);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher(topic);
                eventPublisher.publish(completeApplicationsRequestEvent);
            }
        });
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

