/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application.signup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.signup.ApplicationSignUp;
import org.apache.stratos.messaging.event.application.signup.ApplicationSignUpAddedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationSignUpAddedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationSignUpAddedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (type.equals(ApplicationSignUpAddedEvent.class.getName())) {
            ApplicationSignUpAddedEvent event = (ApplicationSignUpAddedEvent)MessagingUtil.jsonToObject(message, ApplicationSignUpAddedEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to ApplicationSignUpAddedEvent");
                return false;
            }
            if (event.getClusterIds() == null) {
                log.error((Object)String.format("Cluster ids not found in application signup added event: [application] %s [tenant] %d", event.getApplicationId(), event.getTenantId()));
            }
            try {
                ApplicationSignUpManager.acquireWriteLock();
                ApplicationSignUp applicationSignUp = new ApplicationSignUp();
                applicationSignUp.setApplicationId(event.getApplicationId());
                applicationSignUp.setTenantId(event.getTenantId());
                applicationSignUp.setClusterIds(event.getClusterIds().toArray(new String[event.getClusterIds().size()]));
                ApplicationSignUpManager.getInstance().addApplicationSignUp(applicationSignUp);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Application signup added: [application-id] %s [tenant-id] %s", applicationSignUp.getApplicationId(), applicationSignUp.getTenantId()));
                }
            }
            finally {
                ApplicationSignUpManager.releaseWriteLock();
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

